/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.modify;

import com.google.common.base.Objects;
import java.sql.Timestamp;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.publish.PublishedPropertyFacet;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ixn.InteractionDtoServiceInternal;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.schema.ixn.v1.MemberExecutionDto;
import org.apache.isis.schema.ixn.v1.PropertyEditDto;

public abstract class PropertySetterOrClearFacetForDomainEventAbstract
extends SingleValueFacetAbstract<Class<? extends PropertyDomainEvent<?, ?>>> {
    private final DomainEventHelper domainEventHelper;
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final PropertySetterFacet setterFacet;
    private final PropertyClearFacet clearFacet;
    private final PropertyDomainEventFacetAbstract propertyDomainEventFacet;
    private final ServicesInjector servicesInjector;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public PropertySetterOrClearFacetForDomainEventAbstract(Class<? extends Facet> facetType, Class<? extends PropertyDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, PropertySetterFacet setterFacet, PropertyClearFacet clearFacet, PropertyDomainEventFacetAbstract propertyDomainEventFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(facetType, eventType, holder);
        this.getterFacet = getterFacet;
        this.setterFacet = setterFacet;
        this.clearFacet = clearFacet;
        this.propertyDomainEventFacet = propertyDomainEventFacet;
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
        this.servicesInjector = servicesInjector;
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    public void clearProperty(OneToOneAssociation owningProperty, ObjectAdapter targetAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        this.setOrClearProperty(Style.CLEAR, owningProperty, targetAdapter, null, interactionInitiatedBy);
    }

    public void setProperty(OneToOneAssociation owningProperty, ObjectAdapter targetAdapter, ObjectAdapter newValueAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        this.setOrClearProperty(Style.SET, owningProperty, targetAdapter, newValueAdapter, interactionInitiatedBy);
    }

    private void setOrClearProperty(final Style style, final OneToOneAssociation owningProperty, final ObjectAdapter targetAdapter, final ObjectAdapter newValueAdapter, final InteractionInitiatedBy interactionInitiatedBy) {
        this.getPersistenceSessionServiceInternal().executeWithinTransaction(new TransactionalClosure(){

            @Override
            public void execute() {
                PropertySetterOrClearFacetForDomainEventAbstract.this.doSetOrClearProperty(style, owningProperty, targetAdapter, newValueAdapter, interactionInitiatedBy);
            }
        });
    }

    private void doSetOrClearProperty(final Style style, final OneToOneAssociation owningProperty, final ObjectAdapter targetAdapter, final ObjectAdapter newValueAdapter, final InteractionInitiatedBy interactionInitiatedBy) {
        if (!style.hasCorrespondingFacet(this)) {
            return;
        }
        CommandContext commandContext = this.getCommandContext();
        final Command command = commandContext.getCommand();
        InteractionContext interactionContext = this.getInteractionContext();
        Interaction interaction = interactionContext.getInteraction();
        String propertyId = owningProperty.getIdentifier().toClassAndNameIdentityString();
        if (command.getExecutor() == Command.Executor.USER && command.getExecuteIn() == Command.ExecuteIn.BACKGROUND) {
            CommandService commandService = this.getCommandService();
            if (!commandService.persistIfPossible(command)) {
                throw new IsisException(String.format("Unable to persist command for property '%s'; CommandService does not support persistent commands ", propertyId));
            }
        } else {
            Object target = ObjectAdapter.Util.unwrap(targetAdapter);
            Object argValue = ObjectAdapter.Util.unwrap(newValueAdapter);
            String targetMember = CommandUtil.targetMemberNameFor(owningProperty);
            String targetClass = CommandUtil.targetClassNameFor(targetAdapter);
            final Interaction.PropertyEdit execution = new Interaction.PropertyEdit(interaction, propertyId, target, argValue, targetMember, targetClass);
            Interaction.MemberExecutor<Interaction.PropertyEdit> executor = new Interaction.MemberExecutor<Interaction.PropertyEdit>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object execute(Interaction.PropertyEdit currentExecution) {
                    PropertyEditDto editDto = PropertySetterOrClearFacetForDomainEventAbstract.this.getInteractionDtoServiceInternal().asPropertyEditDto(owningProperty, targetAdapter, newValueAdapter);
                    currentExecution.setDto((MemberExecutionDto)editDto);
                    Timestamp startedAt = PropertySetterOrClearFacetForDomainEventAbstract.this.getClockService().nowAsJavaSqlTimestamp();
                    execution.setStartedAt(startedAt);
                    if (command.getStartedAt() == null) {
                        command.setStartedAt(startedAt);
                    }
                    Object oldValue = PropertySetterOrClearFacetForDomainEventAbstract.this.getterFacet.getProperty(targetAdapter, interactionInitiatedBy);
                    Object newValue = ObjectAdapter.Util.unwrap(newValueAdapter);
                    PropertyDomainEvent<?, ?> event = PropertySetterOrClearFacetForDomainEventAbstract.this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.EXECUTING, PropertySetterOrClearFacetForDomainEventAbstract.this.eventType(), null, PropertySetterOrClearFacetForDomainEventAbstract.this.getIdentified(), targetAdapter, oldValue, newValue);
                    currentExecution.setEvent(event);
                    style.invoke(PropertySetterOrClearFacetForDomainEventAbstract.this, owningProperty, targetAdapter, newValueAdapter, interactionInitiatedBy);
                    Object actualNewValue = PropertySetterOrClearFacetForDomainEventAbstract.this.getterFacet.getProperty(targetAdapter, interactionInitiatedBy);
                    if (!Objects.equal((Object)oldValue, (Object)actualNewValue)) {
                        PropertySetterOrClearFacetForDomainEventAbstract.this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.EXECUTED, PropertySetterOrClearFacetForDomainEventAbstract.this.eventType(), PropertySetterOrClearFacetForDomainEventAbstract.this.verify(event), PropertySetterOrClearFacetForDomainEventAbstract.this.getIdentified(), targetAdapter, oldValue, actualNewValue);
                    }
                    Object var8_8 = null;
                    return var8_8;
                }
            };
            interaction.execute((Interaction.MemberExecutor)executor, execution);
            Interaction.Execution priorExecution = interaction.getPriorExecution();
            Exception executionExceptionIfAny = priorExecution.getThrew();
            if (executionExceptionIfAny != null) {
                throw executionExceptionIfAny instanceof RuntimeException ? (RuntimeException)executionExceptionIfAny : new RuntimeException(executionExceptionIfAny);
            }
            PublishedPropertyFacet publishedPropertyFacet = this.getIdentified().getFacet(PublishedPropertyFacet.class);
            if (publishedPropertyFacet != null) {
                this.getPublishingServiceInternal().publishProperty(priorExecution);
            }
        }
    }

    private Class<? extends PropertyDomainEvent<?, ?>> eventType() {
        return (Class)this.value();
    }

    protected PropertyDomainEvent<?, ?> verify(PropertyDomainEvent<?, ?> event) {
        return event;
    }

    private InteractionDtoServiceInternal getInteractionDtoServiceInternal() {
        return this.servicesInjector.lookupServiceElseFail(InteractionDtoServiceInternal.class);
    }

    private CommandContext getCommandContext() {
        return this.servicesInjector.lookupServiceElseFail(CommandContext.class);
    }

    private InteractionContext getInteractionContext() {
        return this.servicesInjector.lookupServiceElseFail(InteractionContext.class);
    }

    private CommandService getCommandService() {
        return this.servicesInjector.lookupServiceElseFail(CommandService.class);
    }

    private ClockService getClockService() {
        return this.servicesInjector.lookupServiceElseFail(ClockService.class);
    }

    private PublishingServiceInternal getPublishingServiceInternal() {
        return this.servicesInjector.lookupServiceElseFail(PublishingServiceInternal.class);
    }

    private PersistenceSessionServiceInternal getPersistenceSessionServiceInternal() {
        return this.persistenceSessionServiceInternal;
    }

    static enum Style {
        SET{

            @Override
            boolean hasCorrespondingFacet(PropertySetterOrClearFacetForDomainEventAbstract facet) {
                return facet.setterFacet != null;
            }

            @Override
            void invoke(PropertySetterOrClearFacetForDomainEventAbstract facet, OneToOneAssociation owningProperty, ObjectAdapter targetAdapter, ObjectAdapter valueAdapterOrNull, InteractionInitiatedBy interactionInitiatedBy) {
                facet.setterFacet.setProperty(owningProperty, targetAdapter, valueAdapterOrNull, interactionInitiatedBy);
            }
        }
        ,
        CLEAR{

            @Override
            boolean hasCorrespondingFacet(PropertySetterOrClearFacetForDomainEventAbstract facet) {
                return facet.clearFacet != null;
            }

            @Override
            void invoke(PropertySetterOrClearFacetForDomainEventAbstract facet, OneToOneAssociation owningProperty, ObjectAdapter targetAdapter, ObjectAdapter valueAdapterOrNull, InteractionInitiatedBy interactionInitiatedBy) {
                facet.clearFacet.clearProperty(owningProperty, targetAdapter, interactionInitiatedBy);
            }
        };


        abstract boolean hasCorrespondingFacet(PropertySetterOrClearFacetForDomainEventAbstract var1);

        abstract void invoke(PropertySetterOrClearFacetForDomainEventAbstract var1, OneToOneAssociation var2, ObjectAdapter var3, ObjectAdapter var4, InteractionInitiatedBy var5);
    }
}

