/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.propertylayout;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacetAbstract;

public class TypicalLengthFacetOnPropertyFromLayoutProperties
extends TypicalLengthFacetAbstract {
    private final int typicalLength;

    public static TypicalLengthFacet create(Properties properties, FacetHolder holder) {
        int typicalLength = TypicalLengthFacetOnPropertyFromLayoutProperties.typicalLength(properties);
        return typicalLength != -1 ? new TypicalLengthFacetOnPropertyFromLayoutProperties(typicalLength, holder) : null;
    }

    private TypicalLengthFacetOnPropertyFromLayoutProperties(int typicalLength, FacetHolder holder) {
        super(holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.typicalLength = typicalLength;
    }

    private static int typicalLength(Properties properties) {
        if (properties == null) {
            return -1;
        }
        String typicalLength = Strings.emptyToNull((String)properties.getProperty("typicalLength"));
        if (typicalLength == null) {
            return -1;
        }
        return Integer.parseInt(typicalLength);
    }

    @Override
    public int value() {
        return this.typicalLength;
    }
}

