/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.update;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.properties.update.NotPersistableFacetInferred;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacetViaClearMethod;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacetViaSetterMethod;
import org.apache.isis.core.metamodel.facets.properties.update.init.PropertyInitializationFacetViaSetterMethod;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacetViaSetterMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class PropertySetAndClearFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"set", "clear"};

    public PropertySetAndClearFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Method setMethod = PropertySetAndClearFacetFactory.attachPropertyModifyFacetIfSetterIsFound(processMethodContext);
        Method clearMethod = this.attachPropertyClearFacetIfClearMethodIsFound(processMethodContext);
        PropertySetAndClearFacetFactory.attachPropertyClearFacetUsingSetterIfRequired(processMethodContext, setMethod, clearMethod);
    }

    private static Method attachPropertyModifyFacetIfSetterIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Method setMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "set" + capitalizedName, Void.TYPE, paramTypes);
        processMethodContext.removeMethod(setMethod);
        Object property = processMethodContext.getFacetHolder();
        if (setMethod != null) {
            FacetUtil.addFacet(new PropertySetterFacetViaSetterMethod(setMethod, (FacetHolder)property));
            FacetUtil.addFacet(new PropertyInitializationFacetViaSetterMethod(setMethod, (FacetHolder)property));
        } else {
            FacetUtil.addFacet(new NotPersistableFacetInferred((FacetHolder)property));
        }
        return setMethod;
    }

    private Method attachPropertyClearFacetIfClearMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        Method getMethod = processMethodContext.getMethod();
        Object property = processMethodContext.getFacetHolder();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Method clearMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "clear" + capitalizedName, Void.TYPE, NO_PARAMETERS_TYPES);
        if (clearMethod == null) {
            return null;
        }
        processMethodContext.removeMethod(clearMethod);
        FacetUtil.addFacet(new PropertyClearFacetViaClearMethod(clearMethod, (FacetHolder)property));
        return clearMethod;
    }

    private static void attachPropertyClearFacetUsingSetterIfRequired(FacetFactory.ProcessMethodContext processMethodContext, Method setMethod, Method clearMethod) {
        if (clearMethod != null) {
            return;
        }
        if (setMethod == null) {
            return;
        }
        Object property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new PropertyClearFacetViaSetterMethod(setMethod, (FacetHolder)property));
    }
}

