/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.bytes;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.bytes.ByteValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class ByteValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Byte>
implements ByteValueFacet {
    private static final Byte DEFAULT_VALUE = 0;
    private static final int MAX_LENGTH = 4;
    private static final int TYPICAL_LENGTH = 4;
    private final NumberFormat format = this.determineNumberFormat("value.format.byte");

    private static Class<? extends Facet> type() {
        return ByteValueFacet.class;
    }

    public ByteValueSemanticsProviderAbstract(FacetHolder holder, Class<Byte> adaptedClass, ServicesInjector context) {
        super(ByteValueSemanticsProviderAbstract.type(), holder, adaptedClass, 4, 4, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected Byte doParse(Object context, String entry) {
        try {
            return this.format.parse(entry).byteValue();
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Byte doRestore(String data) {
        return new Byte(data);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    public Byte byteValue(ObjectAdapter object) {
        return (Byte)object.getObject();
    }

    @Override
    public ObjectAdapter createValue(Byte value) {
        return this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "ByteValueSemanticsProvider: " + this.format;
    }
}

