/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datejodalocal;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.value.JodaFunctions;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;

public final class JodaLocalDateUtil {
    private JodaLocalDateUtil() {
    }

    static LocalDate parseDate(String dateStr, List<DateTimeFormatter> parseFormatters) {
        Locale locale = Locale.getDefault();
        Iterable elements = Iterables.transform(parseFormatters, JodaFunctions.withLocale(locale));
        LocalDate parsedDate = JodaLocalDateUtil.parseDate(dateStr, elements);
        return parsedDate;
    }

    private static LocalDate parseDate(String dateStr, Iterable<DateTimeFormatter> formatters) {
        for (DateTimeFormatter formatter : formatters) {
            try {
                return formatter.parseLocalDate(dateStr);
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new TextEntryParseException("Not recognised as a date: " + dateStr);
    }

    static LocalDate relativeDate(LocalDate contextDate, String str, boolean add) {
        LocalDate relativeDate = contextDate;
        if (str.equals("")) {
            return contextDate;
        }
        try {
            StringTokenizer st = new StringTokenizer(str.substring(1), " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                relativeDate = JodaLocalDateUtil.adjustDate(relativeDate, token, add);
            }
            return relativeDate;
        }
        catch (Exception e) {
            return contextDate;
        }
    }

    private static LocalDate adjustDate(LocalDate contextDate, String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            return JodaLocalDateUtil.add(contextDate, years, months, days, hours, minutes);
        }
        return JodaLocalDateUtil.add(contextDate, -years, -months, -days, -hours, -minutes);
    }

    private static LocalDate add(LocalDate original, int years, int months, int days, int hours, int minutes) {
        if (hours != 0 || minutes != 0) {
            throw new IllegalArgumentException("cannot add non-zero hours or minutes to a LocalDate");
        }
        return original.plusYears(years).plusMonths(months).plusDays(days);
    }

    public static String titleString(DateTimeFormatter formatter, LocalDate date) {
        return date == null ? "" : formatter.print((ReadablePartial)date);
    }
}

