/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.floats;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.floats.FloatingPointValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class FloatValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Float>
implements FloatingPointValueFacet {
    private static final Float DEFAULT_VALUE = new Float(0.0f);
    private static final int MAX_LENGTH = 20;
    private static final int TYPICAL_LENGTH = 12;
    private final NumberFormat format = this.determineNumberFormat("value.format.float");

    public static Class<? extends Facet> type() {
        return FloatingPointValueFacet.class;
    }

    public FloatValueSemanticsProviderAbstract(FacetHolder holder, Class<Float> adaptedClass, ServicesInjector context) {
        super(FloatValueSemanticsProviderAbstract.type(), holder, adaptedClass, 12, 20, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected Float doParse(Object context, String entry) {
        try {
            return new Float(this.format.parse(entry).floatValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a floating point number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Float doRestore(String data) {
        return new Float(data);
    }

    @Override
    public Float floatValue(ObjectAdapter object) {
        return object == null ? null : (Float)object.getObject();
    }

    @Override
    public ObjectAdapter createValue(Float value) {
        return this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "FloatValueSemanticsProvider: " + this.format;
    }
}

