/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layoutmetadata.json;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.services.grid.GridService;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetAbstractImpl;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.facets.object.membergroups.MemberGroupLayoutFacet;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.layoutmetadata.ActionLayoutFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.ActionRepr;
import org.apache.isis.core.metamodel.layoutmetadata.CollectionLayoutFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.ColumnRepr;
import org.apache.isis.core.metamodel.layoutmetadata.CssClassFaFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.CssClassFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.DefaultViewFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.DescribedAsFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.DisabledFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.HiddenFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadata;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader2;
import org.apache.isis.core.metamodel.layoutmetadata.MemberGroupRepr;
import org.apache.isis.core.metamodel.layoutmetadata.MemberRepr;
import org.apache.isis.core.metamodel.layoutmetadata.MultiLineFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.NamedFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.PagedFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.PropertyLayoutFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.RenderFacetRepr;
import org.apache.isis.core.metamodel.layoutmetadata.TypicalLengthFacetRepr;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.grid.fixedcols.applib.Hint;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecifications;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutMetadataReaderFromJson
implements LayoutMetadataReader2,
ServicesInjectorAware {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutMetadataReaderFromJson.class);
    private final Set<Class<?>> blacklisted = Sets.newConcurrentHashSet();
    private static final MemberOrderFacetComparator memberOrderFacetComparator = new MemberOrderFacetComparator(false);
    private ServicesInjector servicesInjector;

    @Override
    public LayoutMetadataReader2.Support support() {
        return LayoutMetadataReader2.Support.entitiesOnly();
    }

    @Override
    public Properties asProperties(Class<?> domainClass) {
        LayoutMetadata metadata = this.readMetadata(domainClass);
        if (metadata == null) {
            return null;
        }
        if (metadata.getColumns() == null || metadata.getColumns().size() != 4) {
            throw new LayoutMetadataReader.ReaderException("JSON metadata must have precisely 4 columns (prop/prop/prop/coll)");
        }
        Properties props = new Properties();
        LayoutMetadataReaderFromJson.setMemberGroupLayoutColumnSpans(metadata, props);
        LayoutMetadataReaderFromJson.setMemberGroupLayoutColumnLists(metadata, 0, "left", props);
        LayoutMetadataReaderFromJson.setMemberGroupLayoutColumnLists(metadata, 1, "middle", props);
        LayoutMetadataReaderFromJson.setMemberGroupLayoutColumnLists(metadata, 2, "right", props);
        int[] memberSeq = new int[]{0};
        LayoutMetadataReaderFromJson.setProperties(metadata, props, memberSeq);
        LayoutMetadataReaderFromJson.setCollections(metadata, props, memberSeq);
        LayoutMetadataReaderFromJson.setFreestandingActions(metadata, props);
        return props;
    }

    private static void setMemberGroupLayoutColumnSpans(LayoutMetadata metadata, Properties props) {
        List<ColumnRepr> columns = metadata.getColumns();
        String columnSpansStr = Joiner.on((String)",").join(Iterables.transform(columns, (Function)new Function<ColumnRepr, Integer>(){

            public Integer apply(ColumnRepr input) {
                return input.span;
            }
        }));
        props.setProperty("class.memberGroupLayout.columnSpans", columnSpansStr);
    }

    private static void setMemberGroupLayoutColumnLists(LayoutMetadata metadata, int colIdx, String propkey, Properties props) {
        ColumnRepr column = metadata.getColumns().get(colIdx);
        Map<String, MemberGroupRepr> memberGroups = column.memberGroups;
        String val = memberGroups != null ? Joiner.on((String)",").join(memberGroups.keySet()) : "";
        props.setProperty("class.memberGroupLayout." + propkey, val);
    }

    private static void setProperties(LayoutMetadata metadata, Properties props, int[] memberSeq) {
        List<ColumnRepr> columns = metadata.getColumns();
        for (ColumnRepr columnRepr : columns) {
            Map<String, MemberGroupRepr> memberGroups = columnRepr.memberGroups;
            if (memberGroups == null) continue;
            for (String memberGroupName : memberGroups.keySet()) {
                MemberGroupRepr memberGroup = memberGroups.get(memberGroupName);
                Map<String, MemberRepr> members = memberGroup.members;
                if (members == null) continue;
                LayoutMetadataReaderFromJson.setMembersAndAssociatedActions(props, memberGroupName, members, memberSeq);
            }
        }
    }

    private static void setCollections(LayoutMetadata metadata, Properties props, int[] memberSeq) {
        ColumnRepr columnRepr = metadata.getColumns().get(3);
        Map<String, MemberRepr> collections = columnRepr.collections;
        LayoutMetadataReaderFromJson.setMembersAndAssociatedActions(props, null, collections, memberSeq);
    }

    private static void setMembersAndAssociatedActions(Properties props, String memberGroupName, Map<String, MemberRepr> members, int[] memberSeq) {
        for (String memberName : members.keySet()) {
            RenderFacetRepr render;
            PagedFacetRepr paged;
            TypicalLengthFacetRepr typicalLength;
            MultiLineFacetRepr multiLine;
            NamedFacetRepr named;
            HiddenFacetRepr hidden;
            DisabledFacetRepr disabled;
            DescribedAsFacetRepr describedAs;
            CssClassFacetRepr cssClass;
            CollectionLayoutFacetRepr collectionLayout;
            PropertyLayoutFacetRepr propertyLayout;
            memberSeq[0] = memberSeq[0] + 1;
            props.setProperty("member." + memberName + ".memberOrder.sequence", "" + memberSeq[0]);
            if (memberGroupName != null) {
                props.setProperty("member." + memberName + ".memberOrder.name", memberGroupName);
            }
            MemberRepr memberRepr = members.get(memberName);
            Map<String, ActionRepr> actions = memberRepr.actions;
            if (actions != null) {
                int actSeq = 0;
                for (String actionName : actions.keySet()) {
                    ActionRepr actionRepr = actions.get(actionName);
                    String nameKey = "action." + actionName + ".memberOrder.name";
                    props.setProperty(nameKey, memberName);
                    LayoutMetadataReaderFromJson.setRemainingActionProperties(props, "action", actionName, actionRepr, ++actSeq);
                }
            }
            if ((propertyLayout = memberRepr.propertyLayout) != null) {
                if (propertyLayout.cssClass != null) {
                    props.setProperty("member." + memberName + ".propertyLayout.cssClass", propertyLayout.cssClass);
                }
                if (propertyLayout.describedAs != null) {
                    props.setProperty("member." + memberName + ".propertyLayout.describedAs", propertyLayout.describedAs);
                }
                if (propertyLayout.hidden != null) {
                    props.setProperty("member." + memberName + ".propertyLayout.hidden", "" + propertyLayout.hidden);
                }
                if (propertyLayout.labelPosition != null) {
                    props.setProperty("member." + memberName + ".propertyLayout.labelPosition", "" + propertyLayout.labelPosition);
                }
                if (propertyLayout.multiLine > 1) {
                    props.setProperty("member." + memberName + ".propertyLayout.multiLine", "" + propertyLayout.multiLine);
                }
                if (propertyLayout.named != null) {
                    props.setProperty("member." + memberName + ".propertyLayout.named", propertyLayout.named);
                }
                props.setProperty("member." + memberName + ".propertyLayout.namedEscaped", "" + propertyLayout.namedEscaped);
                props.setProperty("member." + memberName + ".propertyLayout.renderedAsDayBefore", "" + propertyLayout.renderedAsDayBefore);
                if (propertyLayout.typicalLength > 0) {
                    props.setProperty("member." + memberName + ".propertyLayout.typicalLength", "" + propertyLayout.typicalLength);
                }
            }
            if ((collectionLayout = memberRepr.collectionLayout) != null) {
                if (collectionLayout.cssClass != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.cssClass", collectionLayout.cssClass);
                }
                if (collectionLayout.describedAs != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.describedAs", collectionLayout.describedAs);
                }
                if (collectionLayout.defaultView != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.defaultView", collectionLayout.defaultView);
                }
                if (collectionLayout.hidden != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.hidden", "" + collectionLayout.hidden);
                }
                if (collectionLayout.named != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.named", collectionLayout.named);
                }
                props.setProperty("member." + memberName + ".collectionLayout.namedEscaped", "" + collectionLayout.namedEscaped);
                if (collectionLayout.paged > 0) {
                    props.setProperty("member." + memberName + ".collectionLayout.paged", "" + collectionLayout.paged);
                }
                if (collectionLayout.render != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.render", "" + collectionLayout.render);
                }
                if (collectionLayout.sortedBy != null) {
                    props.setProperty("member." + memberName + ".collectionLayout.sortedBy", collectionLayout.sortedBy);
                }
            }
            if ((cssClass = memberRepr.cssClass) != null) {
                props.setProperty("member." + memberName + ".cssClass.value", cssClass.value);
            }
            if ((describedAs = memberRepr.describedAs) != null) {
                props.setProperty("member." + memberName + ".describedAs.value", describedAs.value);
            }
            if ((disabled = memberRepr.disabled) != null) {
                When disabledWhen = disabled.when != null ? disabled.when : When.ALWAYS;
                props.setProperty("member." + memberName + ".disabled.when", disabledWhen.toString());
                Where disabledWhere = disabled.where != null ? disabled.where : Where.ANYWHERE;
                props.setProperty("member." + memberName + ".disabled.where", disabledWhere.toString());
                String disabledReason = disabled.reason != null ? disabled.reason : "";
                props.setProperty("member." + memberName + ".disabled.reason", disabledReason);
            }
            if ((hidden = memberRepr.hidden) != null) {
                When hiddenWhen = hidden.when != null ? hidden.when : When.ALWAYS;
                props.setProperty("member." + memberName + ".hidden.when", hiddenWhen.toString());
                Where hiddenWhere = hidden.where != null ? hidden.where : Where.ANYWHERE;
                props.setProperty("member." + memberName + ".hidden.where", hiddenWhere.toString());
            }
            if ((named = memberRepr.named) != null) {
                props.setProperty("member." + memberName + ".named.value", named.value);
            }
            if ((multiLine = memberRepr.multiLine) != null) {
                props.setProperty("member." + memberName + ".multiLine.numberOfLines", "" + multiLine.numberOfLines);
            }
            if ((typicalLength = memberRepr.typicalLength) != null) {
                props.setProperty("member." + memberName + ".typicalLength.value", "" + typicalLength.value);
            }
            if ((paged = memberRepr.paged) != null) {
                props.setProperty("member." + memberName + ".paged.value", "" + paged.value);
            }
            if ((render = memberRepr.render) == null) continue;
            Render.Type renderType = render.value != null ? render.value : Render.Type.EAGERLY;
            props.setProperty("member." + memberName + ".render.value", renderType.toString());
        }
    }

    private static void setFreestandingActions(LayoutMetadata metadata, Properties props) {
        if (metadata.getActions() == null) {
            return;
        }
        int xeq = 0;
        Map<String, ActionRepr> actions = metadata.getActions();
        for (String actionName : actions.keySet()) {
            ActionRepr actionRepr = actions.get(actionName);
            LayoutMetadataReaderFromJson.setRemainingActionProperties(props, "member", actionName, actionRepr, ++xeq);
        }
    }

    private static void setRemainingActionProperties(Properties props, String prefix, String actionNameOrig, ActionRepr actionRepr, int seq) {
        NamedFacetRepr actionNamed;
        DescribedAsFacetRepr describedAs;
        CssClassFaFacetRepr cssClassFa;
        CssClassFacetRepr cssClass;
        String actionName = actionNameOrig + ("action".equals(prefix) ? "" : "()");
        props.setProperty(prefix + "." + actionName + ".memberOrder.sequence", "" + seq);
        ActionLayoutFacetRepr actionLayout = actionRepr.actionLayout;
        if (actionLayout != null) {
            if (actionLayout.bookmarking != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.bookmarking", "" + actionLayout.bookmarking);
            }
            if (actionLayout.cssClass != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.cssClass", actionLayout.cssClass);
            }
            if (actionLayout.cssClassFa != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.cssClassFa", actionLayout.cssClassFa);
            }
            if (actionLayout.cssClassFaPosition != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.cssClassFaPosition", actionLayout.cssClassFaPosition);
            }
            if (actionLayout.describedAs != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.describedAs", actionLayout.describedAs);
            }
            if (actionLayout.hidden != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.hidden", "" + actionLayout.hidden);
            }
            if (actionLayout.named != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.named", actionLayout.named);
            }
            props.setProperty(prefix + "." + actionName + ".actionLayout.namedEscaped", "" + actionLayout.namedEscaped);
            if (actionLayout.position != null) {
                props.setProperty(prefix + "." + actionName + ".actionLayout.position", "" + actionLayout.position);
            }
        }
        if ((cssClass = actionRepr.cssClass) != null) {
            props.setProperty(prefix + "." + actionName + ".cssClass.value", cssClass.value);
        }
        if ((cssClassFa = actionRepr.cssClassFa) != null) {
            props.setProperty(prefix + "." + actionName + ".cssClassFa.value", cssClassFa.value);
            props.setProperty(prefix + "." + actionName + ".cssClassFa.position", cssClassFa.position);
        }
        if ((describedAs = actionRepr.describedAs) != null) {
            props.setProperty(prefix + "." + actionName + ".describedAs.value", describedAs.value);
        }
        if ((actionNamed = actionRepr.named) != null) {
            props.setProperty(prefix + "." + actionName + ".named.value", actionNamed.value);
        }
    }

    public LayoutMetadata asLayoutMetadata(Class<?> domainClass) {
        return this.readMetadata(domainClass);
    }

    private LayoutMetadata readMetadata(Class<?> domainClass) {
        String content;
        if (this.blacklisted.contains(domainClass)) {
            return null;
        }
        try {
            GridService gridService = this.getGridService();
            if (gridService.existsFor(domainClass)) {
                this.blacklisted.add(domainClass);
                return null;
            }
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        String resourceName = domainClass.getSimpleName() + ".layout.json";
        try {
            content = ClassExtensions.resourceContentOf(domainClass, resourceName);
        }
        catch (IOException | IllegalArgumentException ex) {
            this.blacklisted.add(domainClass);
            String message = String.format("Failed to locate file %s (relative to %s.class); ex: %s)", resourceName, domainClass.getName(), ex.getMessage());
            LOG.debug(message);
            return null;
        }
        try {
            return this.readMetadata(content);
        }
        catch (Exception ex) {
            String message = "Failed to parse " + domainClass.getName() + ".layout.json file (" + ex.getMessage() + ")";
            LOG.warn(message);
            return null;
        }
    }

    LayoutMetadata readMetadata(String content) {
        Gson gson = new GsonBuilder().create();
        return (LayoutMetadata)gson.fromJson(content, LayoutMetadata.class);
    }

    public String asJson(ObjectSpecification objectSpec) {
        LayoutMetadata metadata = new LayoutMetadata();
        metadata.setColumns(Lists.newArrayList());
        MemberGroupLayoutFacet mglf = objectSpec.getFacet(MemberGroupLayoutFacet.class);
        MemberGroupLayout.ColumnSpans columnSpans = mglf.getColumnSpans();
        TreeSet actionIdsForAssociations = Sets.newTreeSet();
        ColumnRepr columnRepr = LayoutMetadataReaderFromJson.addColumnWithSpan(metadata, columnSpans.getLeft());
        LayoutMetadataReaderFromJson.updateColumnMemberGroups(objectSpec, Hint.LEFT, columnRepr, actionIdsForAssociations);
        columnRepr = LayoutMetadataReaderFromJson.addColumnWithSpan(metadata, columnSpans.getMiddle());
        LayoutMetadataReaderFromJson.updateColumnMemberGroups(objectSpec, Hint.MIDDLE, columnRepr, actionIdsForAssociations);
        columnRepr = LayoutMetadataReaderFromJson.addColumnWithSpan(metadata, columnSpans.getRight());
        LayoutMetadataReaderFromJson.updateColumnMemberGroups(objectSpec, Hint.RIGHT, columnRepr, actionIdsForAssociations);
        columnRepr = LayoutMetadataReaderFromJson.addColumnWithSpan(metadata, columnSpans.getCollections());
        LayoutMetadataReaderFromJson.updateCollectionColumnRepr(objectSpec, columnRepr, actionIdsForAssociations);
        LayoutMetadataReaderFromJson.addActions(objectSpec, metadata, actionIdsForAssociations);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)metadata);
    }

    private static void updateColumnMemberGroups(ObjectSpecification objectSpec, Hint hint, ColumnRepr columnRepr, Set<String> actionIdsForAssociations) {
        List<ObjectAssociation> objectAssociations = LayoutMetadataReaderFromJson.propertiesOf(objectSpec);
        Map<String, List<ObjectAssociation>> associationsByGroup = ObjectAssociation.Util.groupByMemberOrderName(objectAssociations);
        List<String> groupNames = ObjectSpecifications.orderByMemberGroups(objectSpec, associationsByGroup.keySet(), hint);
        columnRepr.memberGroups = Maps.newLinkedHashMap();
        for (String groupName : groupNames) {
            MemberGroupRepr memberGroupRepr = new MemberGroupRepr();
            columnRepr.memberGroups.put(groupName, memberGroupRepr);
            List<ObjectAssociation> associationsInGroup = associationsByGroup.get(groupName);
            memberGroupRepr.members = Maps.newLinkedHashMap();
            if (associationsInGroup == null) continue;
            for (ObjectAssociation assoc : associationsInGroup) {
                MemberRepr memberRepr = LayoutMetadataReaderFromJson.newMemberRepr(objectSpec, assoc, actionIdsForAssociations);
                memberGroupRepr.members.put(assoc.getId(), memberRepr);
            }
        }
    }

    private static void addActions(ObjectSpecification objectSpec, LayoutMetadata metadata, Set<String> actionIdsForAssociations) {
        LinkedHashMap actions = Maps.newLinkedHashMap();
        List<ObjectAction> actionsOf = LayoutMetadataReaderFromJson.actionsOf(objectSpec, actionIdsForAssociations);
        for (ObjectAction action : actionsOf) {
            actions.put(action.getId(), LayoutMetadataReaderFromJson.newActionRepr(objectSpec, action));
        }
        metadata.setActions(actions);
    }

    private static ActionRepr newActionRepr(ObjectSpecification objectSpec, ObjectAction action) {
        NamedFacet namedFacet;
        DescribedAsFacet describedAsFacet;
        ActionRepr actionRepr = new ActionRepr();
        CssClassFacet cssClassFacet = action.getFacet(CssClassFacet.class);
        if (cssClassFacet != null && !cssClassFacet.isNoop()) {
            CssClassFacetRepr cssClassFacetRepr = new CssClassFacetRepr();
            cssClassFacetRepr.value = cssClassFacet.cssClass(null);
            actionRepr.cssClass = cssClassFacetRepr;
        }
        if ((describedAsFacet = action.getFacet(DescribedAsFacet.class)) != null && !describedAsFacet.isNoop() && !Strings.isNullOrEmpty((String)describedAsFacet.value())) {
            DescribedAsFacetRepr describedAsFacetRepr = new DescribedAsFacetRepr();
            describedAsFacetRepr.value = describedAsFacet.value();
            actionRepr.describedAs = describedAsFacetRepr;
        }
        if ((namedFacet = action.getFacet(NamedFacet.class)) != null && !namedFacet.isNoop()) {
            NamedFacetRepr namedFacetRepr = new NamedFacetRepr();
            namedFacetRepr.value = namedFacet.value();
            actionRepr.named = namedFacetRepr;
        }
        return actionRepr;
    }

    private static void updateCollectionColumnRepr(ObjectSpecification objectSpec, ColumnRepr columnRepr, Set<String> actionIdsOfAssociations) {
        List<ObjectAssociation> objectAssociations = LayoutMetadataReaderFromJson.collectionsOf(objectSpec);
        columnRepr.collections = Maps.newLinkedHashMap();
        for (ObjectAssociation assoc : objectAssociations) {
            MemberRepr memberRepr = LayoutMetadataReaderFromJson.newMemberRepr(objectSpec, assoc, actionIdsOfAssociations);
            columnRepr.collections.put(assoc.getId(), memberRepr);
        }
    }

    private static MemberRepr newMemberRepr(ObjectSpecification objectSpec, ObjectAssociation assoc, Set<String> actionIdsForAssociations) {
        List<ObjectAction> actions;
        TypicalLengthFacet typicalLengthFacet;
        RenderFacet renderFacet;
        PagedFacet pagedFacet;
        MultiLineFacet multiLineFacet;
        HiddenFacet hiddenFacet;
        DisabledFacet disabledFacet;
        NamedFacet namedFacet;
        DefaultViewFacet defaultViewFacet;
        DescribedAsFacet describedAsFacet;
        MemberRepr memberRepr = new MemberRepr();
        CssClassFacet cssClassFacet = assoc.getFacet(CssClassFacet.class);
        if (cssClassFacet != null && !cssClassFacet.isNoop()) {
            CssClassFacetRepr cssClassFacetRepr = new CssClassFacetRepr();
            cssClassFacetRepr.value = cssClassFacet.cssClass(null);
            memberRepr.cssClass = cssClassFacetRepr;
        }
        if ((describedAsFacet = assoc.getFacet(DescribedAsFacet.class)) != null && !describedAsFacet.isNoop() && !Strings.isNullOrEmpty((String)describedAsFacet.value())) {
            DescribedAsFacetRepr describedAsFacetRepr = new DescribedAsFacetRepr();
            describedAsFacetRepr.value = describedAsFacet.value();
            memberRepr.describedAs = describedAsFacetRepr;
        }
        if ((defaultViewFacet = assoc.getFacet(DefaultViewFacet.class)) != null && !defaultViewFacet.isNoop() && !Strings.isNullOrEmpty((String)defaultViewFacet.value())) {
            DefaultViewFacetRepr defaultViewFacetRepr = new DefaultViewFacetRepr();
            defaultViewFacetRepr.value = describedAsFacet.value();
        }
        if ((namedFacet = assoc.getFacet(NamedFacet.class)) != null && !namedFacet.isNoop()) {
            NamedFacetRepr namedFacetRepr = new NamedFacetRepr();
            namedFacetRepr.value = namedFacet.value();
            memberRepr.named = namedFacetRepr;
        }
        if ((disabledFacet = assoc.getFacet(DisabledFacet.class)) != null && !disabledFacet.isNoop()) {
            DisabledFacetRepr disabledFacetRepr = new DisabledFacetRepr();
            if (disabledFacet instanceof DisabledFacetAbstractImpl) {
                DisabledFacetAbstractImpl disabledFacetImpl = (DisabledFacetAbstractImpl)disabledFacet;
                disabledFacetRepr.reason = Strings.emptyToNull((String)disabledFacetImpl.getReason());
            }
            disabledFacetRepr.when = LayoutMetadataReaderFromJson.whenAlwaysToNull(disabledFacet.when());
            disabledFacetRepr.where = LayoutMetadataReaderFromJson.whereAnywhereToNull(disabledFacet.where());
            memberRepr.disabled = disabledFacetRepr;
        }
        if ((hiddenFacet = assoc.getFacet(HiddenFacet.class)) != null && !hiddenFacet.isNoop()) {
            HiddenFacetRepr hiddenFacetRepr = new HiddenFacetRepr();
            hiddenFacetRepr.when = LayoutMetadataReaderFromJson.whenAlwaysToNull(hiddenFacet.when());
            hiddenFacetRepr.where = LayoutMetadataReaderFromJson.whereAnywhereToNull(hiddenFacet.where());
            memberRepr.hidden = hiddenFacetRepr;
        }
        if ((multiLineFacet = assoc.getFacet(MultiLineFacet.class)) != null && !multiLineFacet.isNoop()) {
            MultiLineFacetRepr multiLineFacetRepr = new MultiLineFacetRepr();
            multiLineFacetRepr.numberOfLines = multiLineFacet.numberOfLines();
            memberRepr.multiLine = multiLineFacetRepr;
        }
        if ((pagedFacet = assoc.getFacet(PagedFacet.class)) != null && !pagedFacet.isNoop()) {
            PagedFacetRepr pagedFacetRepr = new PagedFacetRepr();
            pagedFacetRepr.value = pagedFacet.value();
            memberRepr.paged = pagedFacetRepr;
        }
        if ((renderFacet = assoc.getFacet(RenderFacet.class)) != null && !renderFacet.isNoop()) {
            RenderFacetRepr renderFacetRepr = new RenderFacetRepr();
            renderFacetRepr.value = (Render.Type)renderFacet.value();
            memberRepr.render = renderFacetRepr;
        }
        if ((typicalLengthFacet = assoc.getFacet(TypicalLengthFacet.class)) != null && !typicalLengthFacet.isNoop()) {
            TypicalLengthFacetRepr typicalLengthFacetRepr = new TypicalLengthFacetRepr();
            typicalLengthFacetRepr.value = typicalLengthFacet.value();
            memberRepr.typicalLength = typicalLengthFacetRepr;
        }
        if (!(actions = objectSpec.getObjectActions(ActionType.USER, Contributed.INCLUDED, ObjectAction.Filters.memberOrderOf(assoc))).isEmpty()) {
            memberRepr.actions = Maps.newLinkedHashMap();
            LayoutMetadataReaderFromJson.sortByMemberOrderFacet(actions);
            for (ObjectAction action : actions) {
                String actionId = action.getId();
                memberRepr.actions.put(actionId, new ActionRepr());
                actionIdsForAssociations.add(actionId);
            }
        }
        return memberRepr;
    }

    private static Where whereAnywhereToNull(Where where) {
        return where != Where.ANYWHERE ? where : null;
    }

    private static When whenAlwaysToNull(When when) {
        return when != When.ALWAYS ? when : null;
    }

    private static void sortByMemberOrderFacet(List<ObjectAction> actions) {
        Collections.sort(actions, new Comparator<ObjectAction>(){

            @Override
            public int compare(ObjectAction o1, ObjectAction o2) {
                MemberOrderFacet m1 = o1.getFacet(MemberOrderFacet.class);
                MemberOrderFacet m2 = o2.getFacet(MemberOrderFacet.class);
                return memberOrderFacetComparator.compare(m1, m2);
            }
        });
    }

    private static ColumnRepr addColumnWithSpan(LayoutMetadata metadata, int span) {
        ColumnRepr col = new ColumnRepr();
        metadata.getColumns().add(col);
        col.span = span;
        return col;
    }

    private static List<ObjectAssociation> propertiesOf(ObjectSpecification objSpec) {
        return objSpec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES);
    }

    private static List<ObjectAssociation> collectionsOf(ObjectSpecification objSpec) {
        return objSpec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.COLLECTIONS);
    }

    private static List<ObjectAction> actionsOf(ObjectSpecification objSpec, Set<String> excludedActionIds) {
        return objSpec.getObjectActions(ActionType.ALL, Contributed.INCLUDED, LayoutMetadataReaderFromJson.excluding(excludedActionIds));
    }

    private static Filter<ObjectAction> excluding(final Set<String> excludedActionIds) {
        return new Filter<ObjectAction>(){

            public boolean accept(ObjectAction t) {
                return !excludedActionIds.contains(t.getId());
            }
        };
    }

    public String toString() {
        return this.getClass().getName();
    }

    private GridService getGridService() {
        return this.servicesInjector.lookupService(GridService.class);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

