/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.methodutils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public enum MethodScope {
    CLASS,
    OBJECT;


    public boolean isClass() {
        return this == CLASS;
    }

    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean doesNotMatchScope(Method method) {
        return !this.matchesScopeOf(method);
    }

    public boolean matchesScopeOf(Method method) {
        return MethodScope.isStatic(method) == this.isClass();
    }

    public static MethodScope scopeFor(Method method) {
        return MethodScope.isStatic(method) ? CLASS : OBJECT;
    }

    private static boolean isStatic(Method method) {
        int modifiers = method.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        return isStatic;
    }
}

