/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.appfeat;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.SortedSet;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureRepositoryDefault;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;

public class ApplicationFeature
implements Comparable<ApplicationFeature> {
    public static final int TYPICAL_LENGTH_PKG_FQN = 50;
    public static final int TYPICAL_LENGTH_CLS_NAME = 50;
    public static final int TYPICAL_LENGTH_MEMBER_NAME = 50;
    private ApplicationFeatureId featureId;
    private ApplicationMemberType memberType;
    private String returnTypeName;
    private boolean contributed;
    private Boolean derived;
    private Integer propertyMaxLength;
    private Integer propertyTypicalLength;
    private SemanticsOf actionSemantics;
    private final SortedSet<ApplicationFeatureId> contents = Sets.newTreeSet();
    private final SortedSet<ApplicationFeatureId> properties = Sets.newTreeSet();
    private final SortedSet<ApplicationFeatureId> collections = Sets.newTreeSet();
    private final SortedSet<ApplicationFeatureId> actions = Sets.newTreeSet();
    private static final String propertyNames = "featureId";

    public ApplicationFeature() {
        this(null);
    }

    public ApplicationFeature(ApplicationFeatureId featureId) {
        this.setFeatureId(featureId);
    }

    @Programmatic
    public ApplicationFeatureId getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(ApplicationFeatureId applicationFeatureId) {
        this.featureId = applicationFeatureId;
    }

    @Programmatic
    public ApplicationMemberType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(ApplicationMemberType memberType) {
        this.memberType = memberType;
    }

    @Programmatic
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public void setReturnTypeName(String returnTypeName) {
        this.returnTypeName = returnTypeName;
    }

    @Programmatic
    public boolean isContributed() {
        return this.contributed;
    }

    public void setContributed(boolean contributed) {
        this.contributed = contributed;
    }

    @Programmatic
    public Boolean isDerived() {
        return this.derived;
    }

    public void setDerived(Boolean derived) {
        this.derived = derived;
    }

    @Programmatic
    public Integer getPropertyMaxLength() {
        return this.propertyMaxLength;
    }

    public void setPropertyMaxLength(Integer propertyMaxLength) {
        this.propertyMaxLength = propertyMaxLength;
    }

    @Programmatic
    public Integer getPropertyTypicalLength() {
        return this.propertyTypicalLength;
    }

    public void setPropertyTypicalLength(Integer propertyTypicalLength) {
        this.propertyTypicalLength = propertyTypicalLength;
    }

    @Programmatic
    public SemanticsOf getActionSemantics() {
        return this.actionSemantics;
    }

    public void setActionSemantics(SemanticsOf actionSemantics) {
        this.actionSemantics = actionSemantics;
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getContents() {
        ApplicationFeatureType.ensurePackage(this.getFeatureId());
        return this.contents;
    }

    @Programmatic
    public void addToContents(ApplicationFeatureId contentId) {
        ApplicationFeatureType.ensurePackage(this.getFeatureId());
        ApplicationFeatureType.ensurePackageOrClass(contentId);
        this.contents.add(contentId);
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getProperties() {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        return this.properties;
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getCollections() {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        return this.collections;
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getActions() {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        return this.actions;
    }

    @Programmatic
    public void addToMembers(ApplicationFeatureId memberId, ApplicationMemberType memberType) {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        ApplicationFeatureType.ensureMember(memberId);
        this.membersOf(memberType).add(memberId);
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> membersOf(ApplicationMemberType memberType) {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        switch (memberType) {
            case PROPERTY: {
                return this.properties;
            }
            case COLLECTION: {
                return this.collections;
            }
        }
        return this.actions;
    }

    @Override
    public int compareTo(ApplicationFeature other) {
        return ObjectContracts.compare((Object)this, (Object)other, (String)propertyNames);
    }

    public boolean equals(Object obj) {
        return ObjectContracts.equals((Object)this, (Object)obj, (String)propertyNames);
    }

    public int hashCode() {
        return ObjectContracts.hashCode((Object)this, (String)propertyNames);
    }

    public String toString() {
        return ObjectContracts.toString((Object)this, (String)propertyNames);
    }

    public static class Predicates {
        private Predicates() {
        }

        public static Predicate<ApplicationFeature> packageContainingClasses(final ApplicationMemberType memberType, final ApplicationFeatureRepositoryDefault applicationFeatures) {
            return new Predicate<ApplicationFeature>(){

                public boolean apply(ApplicationFeature input) {
                    Iterable classIds = Iterables.filter(input.getContents(), ApplicationFeatureId.Predicates.isClassContaining(memberType, applicationFeatures));
                    return classIds.iterator().hasNext();
                }
            };
        }
    }

    public static class Functions {
        public static final Function<? super ApplicationFeature, ? extends String> GET_FQN = new Function<ApplicationFeature, String>(){

            public String apply(ApplicationFeature input) {
                return input.getFeatureId().getFullyQualifiedName();
            }
        };
        public static final Function<ApplicationFeature, ApplicationFeatureId> GET_ID = new Function<ApplicationFeature, ApplicationFeatureId>(){

            public ApplicationFeatureId apply(ApplicationFeature input) {
                return input.getFeatureId();
            }
        };

        private Functions() {
        }
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<ApplicationFeature> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisApplibModule.CollectionDomainEvent<ApplicationFeature, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisApplibModule.PropertyDomainEvent<ApplicationFeature, T> {
    }
}

