/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.appfeat;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.TitleBuffer;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeature;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureRepositoryDefault;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;

@Value
public class ApplicationFeatureId
implements Comparable<ApplicationFeatureId>,
Serializable {
    ApplicationFeatureType type;
    private String packageName;
    private String className;
    private String memberName;
    private static final String propertyNames = "type, packageName, className, memberName";

    public static ApplicationFeatureId newFeature(ApplicationFeatureType featureType, String fullyQualifiedName) {
        switch (featureType) {
            case PACKAGE: {
                return ApplicationFeatureId.newPackage(fullyQualifiedName);
            }
            case CLASS: {
                return ApplicationFeatureId.newClass(fullyQualifiedName);
            }
            case MEMBER: {
                return ApplicationFeatureId.newMember(fullyQualifiedName);
            }
        }
        throw new IllegalArgumentException("Unknown feature type " + (Object)((Object)featureType));
    }

    public static ApplicationFeatureId newFeature(String packageFqn, String className, String memberName) {
        if (className == null) {
            return ApplicationFeatureId.newPackage(packageFqn);
        }
        String classFqn = packageFqn + "." + className;
        if (memberName == null) {
            return ApplicationFeatureId.newClass(classFqn);
        }
        return ApplicationFeatureId.newMember(classFqn, memberName);
    }

    public static ApplicationFeatureId newPackage(String packageFqn) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.PACKAGE);
        featureId.setPackageName(packageFqn);
        return featureId;
    }

    public static ApplicationFeatureId newClass(String classFqn) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.CLASS);
        featureId.type.init(featureId, classFqn);
        return featureId;
    }

    public static ApplicationFeatureId newMember(String classFqn, String memberName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.MEMBER);
        ApplicationFeatureType.CLASS.init(featureId, classFqn);
        featureId.type = ApplicationFeatureType.MEMBER;
        featureId.setMemberName(memberName);
        return featureId;
    }

    public static ApplicationFeatureId newMember(String fullyQualifiedName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.MEMBER);
        featureId.type.init(featureId, fullyQualifiedName);
        return featureId;
    }

    public static ApplicationFeatureId parse(String asString) {
        return new ApplicationFeatureId(asString);
    }

    public static ApplicationFeatureId parseEncoded(String encodedString) {
        return new ApplicationFeatureId(ApplicationFeatureId.base64UrlDecode(encodedString));
    }

    private ApplicationFeatureId(String asString) {
        Iterator iterator = Splitter.on((String)":").split((CharSequence)asString).iterator();
        ApplicationFeatureType type = ApplicationFeatureType.valueOf((String)iterator.next());
        type.init(this, (String)iterator.next());
    }

    ApplicationFeatureId(ApplicationFeatureType type) {
        this.type = type;
    }

    public ApplicationFeatureId(ApplicationFeatureType type, String fullyQualifiedName) {
        type.init(this, fullyQualifiedName);
    }

    public String title() {
        TitleBuffer buf = new TitleBuffer();
        buf.append(this.getFullyQualifiedName());
        return buf.toString();
    }

    @Programmatic
    public String getFullyQualifiedName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getPackageName());
        if (this.getClassName() != null) {
            buf.append(".").append(this.getClassName());
        }
        if (this.getMemberName() != null) {
            buf.append("#").append(this.getMemberName());
        }
        return buf.toString();
    }

    public ApplicationFeatureType getType() {
        return this.type;
    }

    @Programmatic
    public String getPackageName() {
        return this.packageName;
    }

    void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Programmatic
    public String getClassName() {
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    @Programmatic
    public String getMemberName() {
        return this.memberName;
    }

    void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    @Programmatic
    public ApplicationFeatureId getParentPackageId() {
        ApplicationFeatureType.ensurePackageOrClass(this);
        if (this.type == ApplicationFeatureType.CLASS) {
            return ApplicationFeatureId.newPackage(this.getPackageName());
        }
        String packageName = this.getPackageName();
        if (!packageName.contains(".")) {
            return null;
        }
        Iterable split = Splitter.on((String)".").split((CharSequence)packageName);
        ArrayList parts = Lists.newArrayList((Iterable)split);
        parts.remove(parts.size() - 1);
        String parentPackageName = Joiner.on((String)".").join((Iterable)parts);
        return ApplicationFeatureId.newPackage(parentPackageName);
    }

    public ApplicationFeatureId getParentClassId() {
        ApplicationFeatureType.ensureMember(this);
        String classFqn = this.getPackageName() + "." + this.getClassName();
        return ApplicationFeatureId.newClass(classFqn);
    }

    @Programmatic
    public String asString() {
        return Joiner.on((String)":").join((Object)this.type, (Object)this.getFullyQualifiedName(), new Object[0]);
    }

    @Programmatic
    public String asEncodedString() {
        return ApplicationFeatureId.base64UrlEncode(this.asString());
    }

    private static String base64UrlDecode(String str) {
        byte[] bytes = BaseEncoding.base64Url().decode((CharSequence)str);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    private static String base64UrlEncode(String str) {
        byte[] bytes = str.getBytes(Charset.forName("UTF-8"));
        return BaseEncoding.base64Url().encode(bytes);
    }

    @Programmatic
    public List<ApplicationFeatureId> getPathIds() {
        return ApplicationFeatureId.pathIds(this);
    }

    @Programmatic
    public List<ApplicationFeatureId> getParentIds() {
        return ApplicationFeatureId.pathIds(this.getParentId());
    }

    private ApplicationFeatureId getParentId() {
        return this.type == ApplicationFeatureType.MEMBER ? this.getParentClassId() : this.getParentPackageId();
    }

    private static List<ApplicationFeatureId> pathIds(ApplicationFeatureId id) {
        ArrayList featureIds = Lists.newArrayList();
        return Collections.unmodifiableList(ApplicationFeatureId.appendParents(id, featureIds));
    }

    private static List<ApplicationFeatureId> appendParents(ApplicationFeatureId featureId, List<ApplicationFeatureId> parentIds) {
        if (featureId != null) {
            parentIds.add(featureId);
            ApplicationFeatureId.appendParents(featureId.getParentId(), parentIds);
        }
        return parentIds;
    }

    @Override
    public int compareTo(ApplicationFeatureId other) {
        return ObjectContracts.compare((Object)this, (Object)other, (String)propertyNames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationFeatureId that = (ApplicationFeatureId)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.memberName != null ? !this.memberName.equals(that.memberName) : that.memberName != null) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.memberName != null ? this.memberName.hashCode() : 0);
        return result;
    }

    public String toString() {
        switch (this.type) {
            case PACKAGE: {
                return ObjectContracts.toString((Object)this, (String)"type, packageName");
            }
            case CLASS: {
                return ObjectContracts.toString((Object)this, (String)"type, packageName, className");
            }
            case MEMBER: {
                return ObjectContracts.toString((Object)this, (String)propertyNames);
            }
        }
        throw new IllegalStateException("Unknown feature type " + (Object)((Object)this.type));
    }

    public static final class Comparators {
        private Comparators() {
        }

        public static Comparator<ApplicationFeatureId> natural() {
            return new ApplicationFeatureIdComparator();
        }

        static class ApplicationFeatureIdComparator
        implements Comparator<ApplicationFeatureId>,
        Serializable {
            ApplicationFeatureIdComparator() {
            }

            @Override
            public int compare(ApplicationFeatureId o1, ApplicationFeatureId o2) {
                return o1.compareTo(o2);
            }
        }
    }

    public static class Predicates {
        private Predicates() {
        }

        public static Predicate<ApplicationFeatureId> isClassContaining(final ApplicationMemberType memberType, final ApplicationFeatureRepositoryDefault applicationFeatures) {
            return new Predicate<ApplicationFeatureId>(){

                public boolean apply(ApplicationFeatureId input) {
                    if (input.getType() != ApplicationFeatureType.CLASS) {
                        return false;
                    }
                    ApplicationFeature feature = applicationFeatures.findFeature(input);
                    if (feature == null) {
                        return false;
                    }
                    return memberType == null || !feature.membersOf(memberType).isEmpty();
                }
            };
        }

        public static Predicate<ApplicationFeatureId> isClassRecursivelyWithin(final ApplicationFeatureId packageId) {
            return new Predicate<ApplicationFeatureId>(){

                public boolean apply(ApplicationFeatureId input) {
                    return input.getParentIds().contains(packageId);
                }
            };
        }
    }

    public static class Functions {
        public static final Function<ApplicationFeatureId, String> GET_CLASS_NAME = new Function<ApplicationFeatureId, String>(){

            public String apply(ApplicationFeatureId input) {
                return input.getClassName();
            }
        };
        public static final Function<ApplicationFeatureId, String> GET_MEMBER_NAME = new Function<ApplicationFeatureId, String>(){

            public String apply(ApplicationFeatureId input) {
                return input.getMemberName();
            }
        };

        private Functions() {
        }
    }
}

