/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.container;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.PersistFailedException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.RepositoryException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.applib.services.config.ConfigurationService;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerForType;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.title.TitleService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByPattern;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByTitle;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

@DomainService(nature=NatureOfService.DOMAIN)
public class DomainObjectContainerDefault
implements DomainObjectContainer,
ExceptionRecognizer {
    private final ExceptionRecognizer recognizer = new ExceptionRecognizerComposite(new ExceptionRecognizer[]{new ExceptionRecognizerForConcurrencyException(), new ExceptionRecognizerForRecoverableException()});
    @Inject
    SpecificationLoader specificationLoader;
    @Inject
    ConfigurationService configurationService;
    @Inject
    FactoryService factoryService;
    @Inject
    MessageService messageService;
    @Inject
    RepositoryService repositoryService;
    @Inject
    ServiceRegistry serviceRegistry;
    @Inject
    TransactionService transactionService;
    @Inject
    TitleService titleService;
    @Inject
    UserService userService;
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    @Deprecated
    @Programmatic
    public String titleOf(Object domainObject) {
        return this.titleService.titleOf(domainObject);
    }

    @Programmatic
    public String iconNameOf(Object domainObject) {
        return this.titleService.iconNameOf(domainObject);
    }

    @Deprecated
    @Programmatic
    public <T> T newTransientInstance(Class<T> ofClass) {
        return (T)this.factoryService.instantiate(ofClass);
    }

    @Programmatic
    public <T> T newViewModelInstance(Class<T> ofClass, String memento) {
        ObjectSpecification spec = this.specificationLoader.loadSpecification(ofClass);
        if (!spec.containsFacet(ViewModelFacet.class)) {
            throw new IsisException("Type must be a ViewModel: " + ofClass);
        }
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.createViewModelInstance(spec, memento);
        if (adapter.getOid().isViewModel()) {
            return (T)adapter.getObject();
        }
        throw new IsisException("Object instantiated but was not given a ViewModel Oid; please report as a possible defect in Isis: " + ofClass);
    }

    @Deprecated
    @Programmatic
    public <T> T newAggregatedInstance(Object parent, Class<T> ofClass) {
        throw new RuntimeException("Aggregated objects are no longer supported");
    }

    @Deprecated
    @Programmatic
    public <T> T newPersistentInstance(Class<T> ofClass) {
        T newInstance = this.newTransientInstance(ofClass);
        this.persist(newInstance);
        return newInstance;
    }

    @Programmatic
    @Deprecated
    public <T> T newInstance(Class<T> ofClass, Object object) {
        if (this.isPersistent(object)) {
            return this.newPersistentInstance(ofClass);
        }
        return this.newTransientInstance(ofClass);
    }

    @Deprecated
    @Programmatic
    public <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    @Programmatic
    public void remove(Object persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Must specify a reference for disposing an object");
        }
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(persistentObject));
        if (!this.isPersistent(persistentObject)) {
            throw new RepositoryException("Object not persistent: " + adapter);
        }
        this.persistenceSessionServiceInternal.remove(adapter);
    }

    @Programmatic
    public void removeIfNotAlready(Object object) {
        this.repositoryService.remove(object);
    }

    @Deprecated
    @Programmatic
    public <T> T injectServicesInto(T domainObject) {
        return (T)this.serviceRegistry.injectServicesInto(domainObject);
    }

    @Deprecated
    @Programmatic
    public <T> T lookupService(Class<T> service) {
        return (T)this.serviceRegistry.lookupService(service);
    }

    @Deprecated
    @Programmatic
    public <T> Iterable<T> lookupServices(Class<T> service) {
        return this.serviceRegistry.lookupServices(service);
    }

    @Programmatic
    @Deprecated
    public void resolve(Object parent) {
        this.persistenceSessionServiceInternal.resolve(this.unwrapped(parent));
    }

    @Programmatic
    @Deprecated
    public void resolve(Object parent, Object field) {
        this.persistenceSessionServiceInternal.resolve(this.unwrapped(parent), field);
    }

    @Deprecated
    @Programmatic
    public void objectChanged(Object object) {
    }

    @Deprecated
    @Programmatic
    public boolean flush() {
        this.transactionService.flushTransaction();
        return false;
    }

    @Deprecated
    @Programmatic
    public void commit() {
        this.persistenceSessionServiceInternal.commit();
    }

    @Programmatic
    public boolean isValid(Object domainObject) {
        return this.validate(domainObject) == null;
    }

    @Programmatic
    public String validate(Object domainObject) {
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(domainObject));
        InteractionResult validityResult = adapter.getSpecification().isValidResult(adapter, InteractionInitiatedBy.FRAMEWORK);
        return validityResult.getReason();
    }

    @Programmatic
    public boolean isViewModel(Object domainObject) {
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(domainObject));
        return adapter.getSpecification().isViewModel();
    }

    @Programmatic
    public boolean isPersistent(Object domainObject) {
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(domainObject));
        return adapter.representsPersistent();
    }

    @Programmatic
    public void persist(Object domainObject) {
        ObjectAdapter adapter = this.persistenceSessionServiceInternal.adapterFor(this.unwrapped(domainObject));
        if (adapter == null) {
            throw new PersistFailedException("Object not known to framework; instantiate using newTransientInstance(...) rather than simply new'ing up.");
        }
        if (adapter.isParentedCollection()) {
            return;
        }
        if (this.isPersistent(domainObject)) {
            throw new PersistFailedException("Object already persistent; OID=" + adapter.getOid());
        }
        this.persistenceSessionServiceInternal.makePersistent(adapter);
    }

    @Programmatic
    public void persistIfNotAlready(Object object) {
        this.repositoryService.persist(object);
    }

    @Deprecated
    @Programmatic
    public UserMemento getUser() {
        return this.userService.getUser();
    }

    @Deprecated
    @Programmatic
    public String getProperty(String name) {
        return this.configurationService.getProperty(name);
    }

    @Deprecated
    @Programmatic
    public String getProperty(String name, String defaultValue) {
        return this.configurationService.getProperty(name, defaultValue);
    }

    @Deprecated
    @Programmatic
    public List<String> getPropertyNames() {
        return this.configurationService.getPropertyNames();
    }

    @Deprecated
    @Programmatic
    public void informUser(String message) {
        this.messageService.informUser(message);
    }

    @Deprecated
    @Programmatic
    public String informUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return this.messageService.informUser(message, contextClass, contextMethod);
    }

    @Deprecated
    @Programmatic
    public void warnUser(String message) {
        this.messageService.warnUser(message);
    }

    @Deprecated
    @Programmatic
    public String warnUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return this.messageService.warnUser(message, contextClass, contextMethod);
    }

    @Deprecated
    @Programmatic
    public void raiseError(String message) {
        this.messageService.raiseError(message);
    }

    @Deprecated
    @Programmatic
    public String raiseError(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return this.messageService.raiseError(message, contextClass, contextMethod);
    }

    @Programmatic
    public <T> List<T> allInstances(Class<T> type, long ... range) {
        return this.repositoryService.allInstances(type, range);
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> cls, Predicate<? super T> predicate, long ... range) {
        return this.repositoryService.allMatches(cls, predicate, range);
    }

    @Programmatic
    @Deprecated
    public <T> List<T> allMatches(Class<T> cls, Filter<? super T> filter, long ... range) {
        return this.allMatches(cls, (T)Filters.asPredicate(filter), range);
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> type, T pattern, long ... range) {
        Assert.assertTrue("pattern not compatible with type", type.isAssignableFrom(pattern.getClass()));
        return this.allMatches((Query<T>)new QueryFindByPattern<T>(type, pattern, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> type, String title, long ... range) {
        return this.allMatches((Query<T>)new QueryFindByTitle<T>(type, title, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Query<T> query) {
        return this.repositoryService.allMatches(query);
    }

    @Programmatic
    public <T> T firstMatch(Class<T> cls, Predicate<T> predicate) {
        return (T)this.repositoryService.firstMatch(cls, predicate);
    }

    @Programmatic
    @Deprecated
    public <T> T firstMatch(Class<T> cls, Filter<T> filter) {
        return (T)this.firstMatch(cls, (T)Filters.asPredicate(filter));
    }

    @Programmatic
    public <T> T firstMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern, 0L, 1L);
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T firstMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title, 0L, 1L);
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T firstMatch(Query<T> query) {
        this.flush();
        ObjectAdapter firstMatching = this.persistenceSessionServiceInternal.firstMatchingQuery(query);
        return (T)ObjectAdapter.Util.unwrap(firstMatching);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, Predicate<T> predicate) {
        return (T)this.repositoryService.uniqueMatch(type, predicate);
    }

    @Programmatic
    @Deprecated
    public <T> T uniqueMatch(Class<T> type, Filter<T> filter) {
        List<Filter<T>> instances = this.allMatches(type, (T)filter, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + filter);
        }
        return (T)DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " matching pattern " + pattern);
        }
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " with title " + title);
        }
        return DomainObjectContainerDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Query<T> query) {
        return (T)this.repositoryService.uniqueMatch(query);
    }

    private static <T> T firstInstanceElseNull(List<T> instances) {
        return instances.size() == 0 ? null : (T)instances.get(0);
    }

    @Programmatic
    public String recognize(Throwable ex) {
        return this.recognizer.recognize(ex);
    }

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
        this.injectServicesInto(this.recognizer);
        this.recognizer.init(properties);
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        this.recognizer.shutdown();
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    static class ExceptionRecognizerForRecoverableException
    extends ExceptionRecognizerForType {
        public ExceptionRecognizerForRecoverableException() {
            super(ExceptionRecognizer2.Category.CLIENT_ERROR, RecoverableException.class);
        }
    }

    static class ExceptionRecognizerForConcurrencyException
    extends ExceptionRecognizerForType {
        public ExceptionRecognizerForConcurrencyException() {
            super(ExceptionRecognizer2.Category.CONCURRENCY, ConcurrencyException.class, ExceptionRecognizerForConcurrencyException.prefix((String)"Another user has just changed this data"));
        }
    }
}

