/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.Grid;
import org.apache.isis.applib.services.grid.GridLoaderService;
import org.apache.isis.applib.services.grid.GridSystemService;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class GridLoaderServiceDefault
implements GridLoaderService {
    private static final Logger LOG = LoggerFactory.getLogger(GridLoaderServiceDefault.class);
    private final Map<Class<?>, String> badXmlByClass = Maps.newHashMap();
    private final Map<String, Grid> gridByXml = Maps.newHashMap();
    private List<Class<? extends Grid>> pageImplementations;
    @Inject
    DeploymentCategoryProvider deploymentCategoryProvider;
    @Inject
    DomainObjectContainer container;
    @Inject
    JaxbService jaxbService;
    @Inject
    List<GridSystemService> gridSystemServices;

    @PostConstruct
    public void init() {
        this.pageImplementations = FluentIterable.from(this.gridSystemServices).transform((Function)new Function<GridSystemService, Class<? extends Grid>>(){

            public Class<? extends Grid> apply(GridSystemService gridSystemService) {
                return gridSystemService.gridImplementation();
            }
        }).toList();
    }

    public boolean supportsReloading() {
        return !this.deploymentCategoryProvider.getDeploymentCategory().isProduction();
    }

    public void remove(Class<?> domainClass) {
        if (!this.supportsReloading()) {
            return;
        }
        this.badXmlByClass.remove(domainClass);
        String xml = this.loadXml(domainClass);
        if (xml == null) {
            return;
        }
        this.gridByXml.remove(xml);
    }

    @Programmatic
    public boolean existsFor(Class<?> domainClass) {
        URL resource = Resources.getResource(domainClass, (String)this.resourceNameFor(domainClass));
        return resource != null;
    }

    @Programmatic
    public Grid load(Class<?> domainClass) {
        String xml = this.loadXml(domainClass);
        if (xml == null) {
            return null;
        }
        if (this.supportsReloading()) {
            Grid grid = this.gridByXml.get(xml);
            if (grid != null) {
                return grid;
            }
            String badXml = this.badXmlByClass.get(domainClass);
            if (badXml != null) {
                if (Objects.equals(xml, badXml)) {
                    return null;
                }
                this.badXmlByClass.remove(domainClass);
            }
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])this.pageImplementations.toArray(new Class[0]));
            Grid grid = (Grid)this.jaxbService.fromXml(context, xml);
            grid.setDomainClass(domainClass);
            if (this.supportsReloading()) {
                this.gridByXml.put(xml, grid);
            }
            return grid;
        }
        catch (Exception ex) {
            if (this.supportsReloading()) {
                this.badXmlByClass.put(domainClass, xml);
            }
            String resourceName = this.resourceNameFor(domainClass);
            String message = "Failed to parse " + resourceName + " file (" + ex.getMessage() + ")";
            if (this.supportsReloading()) {
                this.container.warnUser(message);
            }
            LOG.warn(message);
            return null;
        }
    }

    private String loadXml(Class<?> domainClass) {
        String resourceName = this.resourceNameFor(domainClass);
        try {
            return GridLoaderServiceDefault.resourceContentOf(domainClass, resourceName);
        }
        catch (IOException | IllegalArgumentException ex) {
            if (LOG.isDebugEnabled()) {
                String message = String.format("Failed to locate file %s (relative to %s.class); ex: %s)", resourceName, domainClass.getName(), ex.getMessage());
                LOG.debug(message);
            }
            return null;
        }
    }

    private static String resourceContentOf(Class<?> cls, String resourceName) throws IOException {
        URL url = Resources.getResource(cls, (String)resourceName);
        return Resources.toString((URL)url, (Charset)Charset.defaultCharset());
    }

    private String resourceNameFor(Class<?> domainClass) {
        return domainClass.getSimpleName() + ".layout.xml";
    }
}

