/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.Grid;
import org.apache.isis.applib.services.grid.GridLoaderService;
import org.apache.isis.applib.services.grid.GridService;
import org.apache.isis.applib.services.grid.GridSystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class GridServiceDefault
implements GridService {
    private static final Logger LOG = LoggerFactory.getLogger(GridServiceDefault.class);
    public static final String COMMON_TNS = "http://isis.apache.org/applib/layout/component";
    public static final String COMMON_SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/component/component.xsd";
    private List<GridSystemService<?>> filteredGridSystemServices;
    @Inject
    GridLoaderService gridLoaderService;
    @Inject
    List<GridSystemService> gridSystemServices;

    public boolean supportsReloading() {
        return this.gridLoaderService.supportsReloading();
    }

    public void remove(Class<?> domainClass) {
        this.gridLoaderService.remove(domainClass);
    }

    @Programmatic
    public boolean existsFor(Class<?> domainClass) {
        return this.gridLoaderService.existsFor(domainClass);
    }

    @Programmatic
    public Grid load(Class<?> domainClass) {
        return this.gridLoaderService.load(domainClass);
    }

    @Programmatic
    public Grid defaultGridFor(Class<?> domainClass) {
        for (GridSystemService<?> gridSystemService : this.gridNormalizerServices()) {
            Grid grid = gridSystemService.defaultGrid(domainClass);
            if (grid == null) continue;
            return grid;
        }
        throw new IllegalStateException("No GridNormalizerService available to create grid for '" + domainClass.getName() + "'");
    }

    public Grid normalize(Grid grid) {
        if (grid.isNormalized()) {
            return grid;
        }
        Class domainClass = grid.getDomainClass();
        for (GridSystemService<?> gridSystemService : this.gridNormalizerServices()) {
            gridSystemService.normalize(grid, domainClass);
        }
        String tnsAndSchemaLocation = this.tnsAndSchemaLocation(grid);
        grid.setTnsAndSchemaLocation(tnsAndSchemaLocation);
        grid.setNormalized(true);
        return grid;
    }

    @Programmatic
    public Grid complete(Grid grid) {
        Class domainClass = grid.getDomainClass();
        for (GridSystemService<?> gridSystemService : this.gridNormalizerServices()) {
            gridSystemService.complete(grid, domainClass);
        }
        return grid;
    }

    @Programmatic
    public Grid minimal(Grid grid) {
        Class domainClass = grid.getDomainClass();
        for (GridSystemService<?> gridSystemService : this.gridNormalizerServices()) {
            gridSystemService.minimal(grid, domainClass);
        }
        return grid;
    }

    @Programmatic
    public String tnsAndSchemaLocation(Grid grid) {
        ArrayList parts = Lists.newArrayList();
        parts.add(COMMON_TNS);
        parts.add(COMMON_SCHEMA_LOCATION);
        for (GridSystemService gridSystemService : this.gridSystemServices) {
            Class gridImpl = gridSystemService.gridImplementation();
            if (!gridImpl.isAssignableFrom(grid.getClass())) continue;
            parts.add(gridSystemService.tns());
            parts.add(gridSystemService.schemaLocation());
        }
        return Joiner.on((String)" ").join((Iterable)parts);
    }

    @Programmatic
    protected List<GridSystemService<?>> gridNormalizerServices() {
        if (this.filteredGridSystemServices == null) {
            ArrayList services = Lists.newArrayList();
            for (GridSystemService gridSystemService : this.gridSystemServices) {
                final Class gridImplementation = gridSystemService.gridImplementation();
                boolean notSeenBefore = FluentIterable.from((Iterable)services).filter(new Predicate<GridSystemService<?>>(){

                    public boolean apply(@Nullable GridSystemService<?> gridNormalizerService) {
                        return gridNormalizerService.gridImplementation() == gridImplementation;
                    }
                }).isEmpty();
                if (!notSeenBefore) continue;
                services.add(gridSystemService);
            }
            this.filteredGridSystemServices = services;
        }
        return this.filteredGridSystemServices;
    }
}

