/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid.bootstrap3;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.Grid;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowContentOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.Size;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.membergroups.MemberGroupLayoutFacet;
import org.apache.isis.core.metamodel.services.grid.GridSystemServiceAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

@DomainService(nature=NatureOfService.DOMAIN)
public class GridSystemServiceBS3
extends GridSystemServiceAbstract<BS3Grid> {
    public static final String TNS = "http://isis.apache.org/applib/layout/grid/bootstrap3";
    public static final String SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/grid/bootstrap3/bootstrap3.xsd";

    public GridSystemServiceBS3() {
        super(BS3Grid.class, TNS, SCHEMA_LOCATION);
    }

    @Programmatic
    public Grid defaultGrid(Class<?> domainClass) {
        BS3Grid bs3Grid = new BS3Grid();
        ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
        bs3Grid.setDomainClass(domainClass);
        BS3Row headerRow = new BS3Row();
        bs3Grid.getRows().add(headerRow);
        BS3Col headerRowCol = new BS3Col();
        headerRowCol.setSpan(12);
        headerRowCol.setUnreferencedActions(Boolean.valueOf(true));
        headerRowCol.setDomainObject(new DomainObjectLayoutData());
        headerRow.getCols().add(headerRowCol);
        BS3Row propsRow = new BS3Row();
        bs3Grid.getRows().add(propsRow);
        MemberGroupLayoutFacet memberGroupLayoutFacet = objectSpec.getFacet(MemberGroupLayoutFacet.class);
        if (memberGroupLayoutFacet != null) {
            MemberGroupLayout.ColumnSpans columnSpans = memberGroupLayoutFacet.getColumnSpans();
            GridSystemServiceBS3.addFieldSetsToColumn(propsRow, columnSpans.getLeft(), memberGroupLayoutFacet.getLeft(), true);
            GridSystemServiceBS3.addFieldSetsToColumn(propsRow, columnSpans.getMiddle(), memberGroupLayoutFacet.getMiddle(), false);
            GridSystemServiceBS3.addFieldSetsToColumn(propsRow, columnSpans.getRight(), memberGroupLayoutFacet.getRight(), false);
            BS3Col col = new BS3Col();
            int collectionSpan = columnSpans.getCollections();
            col.setUnreferencedCollections(Boolean.valueOf(true));
            col.setSpan(collectionSpan > 0 ? collectionSpan : 12);
            propsRow.getCols().add(col);
            List<OneToManyAssociation> collections = objectSpec.getCollections(Contributed.INCLUDED);
            for (OneToManyAssociation collection : collections) {
                col.getCollections().add(new CollectionLayoutData(collection.getId()));
            }
        } else {
            GridSystemServiceBS3.addFieldSetsToColumn(propsRow, 4, Arrays.asList("General"), true);
            BS3Col col = new BS3Col();
            col.setUnreferencedCollections(Boolean.valueOf(true));
            col.setSpan(12);
            propsRow.getCols().add(col);
        }
        return bs3Grid;
    }

    static void addFieldSetsToColumn(BS3Row propsRow, int span, List<String> memberGroupNames, boolean unreferencedProperties) {
        if (span > 0 || unreferencedProperties) {
            BS3Col col = new BS3Col();
            col.setSpan(span);
            propsRow.getCols().add(col);
            List<String> leftMemberGroups = memberGroupNames;
            for (String memberGroup : leftMemberGroups) {
                FieldSet fieldSet = new FieldSet();
                fieldSet.setName(memberGroup);
                if (unreferencedProperties && col.getFieldSets().isEmpty()) {
                    fieldSet.setUnreferencedProperties(Boolean.valueOf(true));
                }
                col.getFieldSets().add(fieldSet);
            }
        }
    }

    @Override
    protected boolean validateAndNormalize(Grid grid, Class<?> domainClass) {
        ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
        final HashMap<String, OneToOneAssociation> oneToOneAssociationById = ObjectMember.Util.mapById(GridSystemServiceBS3.getOneToOneAssociations(objectSpec));
        final HashMap<String, OneToManyAssociation> oneToManyAssociationById = ObjectMember.Util.mapById(GridSystemServiceBS3.getOneToManyAssociations(objectSpec));
        final HashMap objectActionById = ObjectMember.Util.mapById(FluentIterable.from(objectSpec.getObjectActions(Contributed.INCLUDED)).filter(Filters.asPredicate(ObjectAction.Filters.notBulkOnly())).toList());
        BS3Grid bs3Grid = (BS3Grid)grid;
        LinkedHashMap propertyLayoutDataById = bs3Grid.getAllPropertiesById();
        LinkedHashMap collectionLayoutDataById = bs3Grid.getAllCollectionsById();
        LinkedHashMap actionLayoutDataById = bs3Grid.getAllActionsById();
        final ArrayList gridIds = Lists.newArrayList();
        final LinkedHashMap rowIds = Maps.newLinkedHashMap();
        final LinkedHashMap colIds = Maps.newLinkedHashMap();
        final LinkedHashMap fieldSetIds = Maps.newLinkedHashMap();
        final AtomicReference<Boolean> duplicateIdDetected = new AtomicReference<Boolean>(false);
        bs3Grid.visit((Grid.Visitor)new BS3Grid.VisitorAdapter(){

            public void visit(BS3Row bs3Row) {
                String id = bs3Row.getId();
                if (id == null) {
                    return;
                }
                if (gridIds.contains(id)) {
                    bs3Row.setMetadataError("There is another element in the grid with this id");
                    duplicateIdDetected.set(true);
                    return;
                }
                rowIds.put(id, bs3Row);
                gridIds.add(id);
            }

            public void visit(BS3Col bs3Col) {
                String id = bs3Col.getId();
                if (id == null) {
                    return;
                }
                if (gridIds.contains(id)) {
                    bs3Col.setMetadataError("There is another element in the grid with this id");
                    duplicateIdDetected.set(true);
                    return;
                }
                colIds.put(id, bs3Col);
                gridIds.add(id);
            }

            public void visit(FieldSet fieldSet) {
                String id = fieldSet.getId();
                if (id == null) {
                    String name = fieldSet.getName();
                    id = GridSystemServiceBS3.asId(name);
                    fieldSet.setId(id);
                }
                if (gridIds.contains(id)) {
                    fieldSet.setMetadataError("There is another element in the grid with this id");
                    duplicateIdDetected.set(true);
                    return;
                }
                fieldSetIds.put(id, fieldSet);
                gridIds.add(id);
            }
        });
        if (duplicateIdDetected.get().booleanValue()) {
            return false;
        }
        final AtomicReference colForUnreferencedActionsRef = new AtomicReference();
        final AtomicReference colForUnreferencedCollectionsRef = new AtomicReference();
        final AtomicReference fieldSetForUnreferencedActionsRef = new AtomicReference();
        final AtomicReference fieldSetForUnreferencedPropertiesRef = new AtomicReference();
        final AtomicReference tabGroupForUnreferencedCollectionsRef = new AtomicReference();
        bs3Grid.visit((Grid.Visitor)new BS3Grid.VisitorAdapter(){

            public void visit(BS3Col bs3Col) {
                if (GridSystemServiceBS3.isSet(bs3Col.isUnreferencedActions()).booleanValue()) {
                    if (colForUnreferencedActionsRef.get() != null) {
                        bs3Col.setMetadataError("More than one col with 'unreferencedActions' attribute set");
                    } else if (fieldSetForUnreferencedActionsRef.get() != null) {
                        bs3Col.setMetadataError("Already found a fieldset with 'unreferencedActions' attribute set");
                    } else {
                        colForUnreferencedActionsRef.set(bs3Col);
                    }
                }
                if (GridSystemServiceBS3.isSet(bs3Col.isUnreferencedCollections()).booleanValue()) {
                    if (colForUnreferencedCollectionsRef.get() != null) {
                        bs3Col.setMetadataError("More than one col with 'unreferencedCollections' attribute set");
                    } else if (tabGroupForUnreferencedCollectionsRef.get() != null) {
                        bs3Col.setMetadataError("Already found a tabgroup with 'unreferencedCollections' attribute set");
                    } else {
                        colForUnreferencedCollectionsRef.set(bs3Col);
                    }
                }
            }

            public void visit(FieldSet fieldSet) {
                if (GridSystemServiceBS3.isSet(fieldSet.isUnreferencedActions()).booleanValue()) {
                    if (fieldSetForUnreferencedActionsRef.get() != null) {
                        fieldSet.setMetadataError("More than one fieldset with 'unreferencedActions' attribute set");
                    } else if (colForUnreferencedActionsRef.get() != null) {
                        fieldSet.setMetadataError("Already found a column with 'unreferencedActions' attribute set");
                    } else {
                        fieldSetForUnreferencedActionsRef.set(fieldSet);
                    }
                }
                if (GridSystemServiceBS3.isSet(fieldSet.isUnreferencedProperties()).booleanValue()) {
                    if (fieldSetForUnreferencedPropertiesRef.get() != null) {
                        fieldSet.setMetadataError("More than one col with 'unreferencedProperties' attribute set");
                    } else {
                        fieldSetForUnreferencedPropertiesRef.set(fieldSet);
                    }
                }
            }

            public void visit(BS3TabGroup bs3TabGroup) {
                if (GridSystemServiceBS3.isSet(bs3TabGroup.isUnreferencedCollections()).booleanValue()) {
                    if (tabGroupForUnreferencedCollectionsRef.get() != null) {
                        bs3TabGroup.setMetadataError("More than one tabgroup with 'unreferencedCollections' attribute set");
                    } else if (colForUnreferencedCollectionsRef.get() != null) {
                        bs3TabGroup.setMetadataError("Already found a column with 'unreferencedCollections' attribute set");
                    } else {
                        tabGroupForUnreferencedCollectionsRef.set(bs3TabGroup);
                    }
                }
            }
        });
        if (colForUnreferencedActionsRef.get() == null && fieldSetForUnreferencedActionsRef.get() == null) {
            bs3Grid.getMetadataErrors().add("No column and also no fieldset found with the 'unreferencedActions' attribute set");
        }
        if (fieldSetForUnreferencedPropertiesRef.get() == null) {
            bs3Grid.getMetadataErrors().add("No fieldset found with the 'unreferencedProperties' attribute set");
        }
        if (colForUnreferencedCollectionsRef.get() == null && tabGroupForUnreferencedCollectionsRef.get() == null) {
            bs3Grid.getMetadataErrors().add("No column and also no tabgroup found with the 'unreferencedCollections' attribute set");
        }
        if (colForUnreferencedActionsRef.get() == null && fieldSetForUnreferencedActionsRef.get() == null || fieldSetForUnreferencedPropertiesRef.get() == null || colForUnreferencedCollectionsRef.get() == null && tabGroupForUnreferencedCollectionsRef.get() == null) {
            return false;
        }
        GridSystemServiceAbstract.Tuple propertyIdTuple = GridSystemServiceBS3.surplusAndMissing(propertyLayoutDataById.keySet(), oneToOneAssociationById.keySet());
        List surplusPropertyIds = (List)propertyIdTuple.first;
        List missingPropertyIds = (List)propertyIdTuple.second;
        for (String surplusPropertyId : surplusPropertyIds) {
            ((PropertyLayoutData)propertyLayoutDataById.get(surplusPropertyId)).setMetadataError("No such property");
        }
        HashMap boundAssociationIdsByFieldSetId = Maps.newHashMap();
        for (FieldSet fieldSet : fieldSetIds.values()) {
            String fieldSetId = fieldSet.getId();
            Set boundAssociationIds = (Set)boundAssociationIdsByFieldSetId.get(fieldSetId);
            if (boundAssociationIds != null) continue;
            boundAssociationIds = Sets.newLinkedHashSet();
            boundAssociationIds.addAll(FluentIterable.from((Iterable)fieldSet.getProperties()).transform((Function)new Function<PropertyLayoutData, String>(){

                public String apply(@Nullable PropertyLayoutData propertyLayoutData) {
                    return propertyLayoutData.getId();
                }
            }).toList());
            boundAssociationIdsByFieldSetId.put(fieldSetId, boundAssociationIds);
        }
        for (OneToOneAssociation otoa : oneToOneAssociationById.values()) {
            String id;
            MemberOrderFacet memberOrderFacet = otoa.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet == null || !fieldSetIds.containsKey(id = GridSystemServiceBS3.asId(memberOrderFacet.name()))) continue;
            Set boundAssociationIds = (Set)boundAssociationIdsByFieldSetId.get(id);
            if (boundAssociationIds == null) {
                boundAssociationIds = Sets.newLinkedHashSet();
                boundAssociationIdsByFieldSetId.put(id, boundAssociationIds);
            }
            boundAssociationIds.add(otoa.getId());
        }
        if (!missingPropertyIds.isEmpty()) {
            FieldSet fieldSet;
            ArrayList unboundPropertyIds = Lists.newArrayList((Iterable)missingPropertyIds);
            for (String fieldSetId : boundAssociationIdsByFieldSetId.keySet()) {
                Set boundPropertyIds = (Set)boundAssociationIdsByFieldSetId.get(fieldSetId);
                unboundPropertyIds.removeAll(boundPropertyIds);
            }
            for (String fieldSetId : boundAssociationIdsByFieldSetId.keySet()) {
                FieldSet fieldSet2 = (FieldSet)fieldSetIds.get(fieldSetId);
                Set associationIds = (Set)boundAssociationIdsByFieldSetId.get(fieldSetId);
                ArrayList associations = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)associationIds).transform((Function)new Function<String, OneToOneAssociation>(){

                    @Nullable
                    public OneToOneAssociation apply(String propertyId) {
                        return (OneToOneAssociation)oneToOneAssociationById.get(propertyId);
                    }
                }).filter(Predicates.notNull()));
                Collections.sort(associations, ObjectMember.Comparators.byMemberOrderSequence());
                this.addPropertiesTo(fieldSet2, (List<String>)FluentIterable.from((Iterable)associations).transform(ObjectAssociation.Functions.toId()).toList(), propertyLayoutDataById);
            }
            if (!unboundPropertyIds.isEmpty() && (fieldSet = (FieldSet)fieldSetForUnreferencedPropertiesRef.get()) != null) {
                this.addPropertiesTo(fieldSet, unboundPropertyIds, propertyLayoutDataById);
            }
        }
        GridSystemServiceAbstract.Tuple collectionIdTuple = GridSystemServiceBS3.surplusAndMissing(collectionLayoutDataById.keySet(), oneToManyAssociationById.keySet());
        List surplusCollectionIds = (List)collectionIdTuple.first;
        List missingCollectionIds = (List)collectionIdTuple.second;
        for (String surplusCollectionId : surplusCollectionIds) {
            ((CollectionLayoutData)collectionLayoutDataById.get(surplusCollectionId)).setMetadataError("No such collection");
        }
        if (!missingCollectionIds.isEmpty()) {
            ArrayList sortedCollections = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)missingCollectionIds).transform((Function)new Function<String, OneToManyAssociation>(){

                @Nullable
                public OneToManyAssociation apply(@Nullable String collectionId) {
                    return (OneToManyAssociation)oneToManyAssociationById.get(collectionId);
                }
            }).toSortedList(ObjectMember.Comparators.byMemberOrderSequence()));
            ImmutableList sortedMissingCollectionIds = FluentIterable.from((Iterable)sortedCollections).transform(ObjectAssociation.Functions.toId()).toList();
            BS3TabGroup bs3TabGroup = (BS3TabGroup)tabGroupForUnreferencedCollectionsRef.get();
            if (bs3TabGroup != null) {
                this.addCollectionsTo(bs3TabGroup, (List<String>)sortedMissingCollectionIds, objectSpec);
            } else {
                BS3Col bs3Col = (BS3Col)colForUnreferencedCollectionsRef.get();
                if (bs3Col != null) {
                    this.addCollectionsTo(bs3Col, (List<String>)sortedMissingCollectionIds, collectionLayoutDataById);
                }
            }
        }
        GridSystemServiceAbstract.Tuple actionIdTuple = GridSystemServiceBS3.surplusAndMissing(actionLayoutDataById.keySet(), objectActionById.keySet());
        List surplusActionIds = (List)actionIdTuple.first;
        List possiblyMissingActionIds = (List)actionIdTuple.second;
        ArrayList associatedActionIds = Lists.newArrayList();
        ArrayList sortedPossiblyMissingActions = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)possiblyMissingActionIds).transform((Function)new Function<String, ObjectAction>(){

            @Nullable
            public ObjectAction apply(@Nullable String actionId) {
                return (ObjectAction)objectActionById.get(actionId);
            }
        }).toSortedList(ObjectMember.Comparators.byMemberOrderSequence()));
        ImmutableList sortedPossiblyMissingActionIds = FluentIterable.from((Iterable)sortedPossiblyMissingActions).transform(ObjectMember.Functions.getId()).toList();
        for (String actionId : sortedPossiblyMissingActionIds) {
            ActionLayoutData actionLayoutData;
            String memberOrderName;
            ObjectAction oa = (ObjectAction)objectActionById.get(actionId);
            MemberOrderFacet memberOrderFacet = oa.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet == null || (memberOrderName = memberOrderFacet.name()) == null) continue;
            String id = GridSystemServiceBS3.asId(memberOrderName);
            if (oneToOneAssociationById.containsKey(id)) {
                PropertyLayoutData owner;
                ActionLayout.Position position;
                associatedActionIds.add(actionId);
                if (memberOrderFacet instanceof MemberOrderFacetAnnotation) continue;
                PropertyLayoutData propertyLayoutData = (PropertyLayoutData)propertyLayoutDataById.get(id);
                actionLayoutData = new ActionLayoutData(actionId);
                ActionPositionFacet actionPositionFacet = oa.getFacet(ActionPositionFacet.class);
                if (actionPositionFacet != null) {
                    position = actionPositionFacet.position();
                    owner = position == ActionLayout.Position.PANEL || position == ActionLayout.Position.PANEL_DROPDOWN ? propertyLayoutData.getOwner() : propertyLayoutData;
                } else {
                    position = ActionLayout.Position.BELOW;
                    owner = propertyLayoutData;
                }
                actionLayoutData.setPosition(position);
                this.addActionTo((ActionLayoutDataOwner)owner, actionLayoutData);
                continue;
            }
            if (oneToManyAssociationById.containsKey(id)) {
                associatedActionIds.add(actionId);
                if (memberOrderFacet instanceof MemberOrderFacetAnnotation) continue;
                CollectionLayoutData collectionLayoutData = (CollectionLayoutData)collectionLayoutDataById.get(id);
                actionLayoutData = new ActionLayoutData(actionId);
                this.addActionTo((ActionLayoutDataOwner)collectionLayoutData, actionLayoutData);
                continue;
            }
            Set boundAssociationIds = (Set)boundAssociationIdsByFieldSetId.get(id);
            if (boundAssociationIds == null || boundAssociationIds.isEmpty()) continue;
            associatedActionIds.add(actionId);
            actionLayoutData = new ActionLayoutData(actionId);
            actionLayoutData.setPosition(ActionLayout.Position.PANEL_DROPDOWN);
            FieldSet fieldSet = (FieldSet)fieldSetIds.get(id);
            this.addActionTo((ActionLayoutDataOwner)fieldSet, actionLayoutData);
        }
        ArrayList missingActionIds = Lists.newArrayList((Iterable)sortedPossiblyMissingActionIds);
        missingActionIds.removeAll(associatedActionIds);
        for (String surplusActionId : surplusActionIds) {
            ((ActionLayoutData)actionLayoutDataById.get(surplusActionId)).setMetadataError("No such action");
        }
        if (!missingActionIds.isEmpty()) {
            BS3Col bs3Col = (BS3Col)colForUnreferencedActionsRef.get();
            if (bs3Col != null) {
                this.addActionsTo(bs3Col, (List<String>)missingActionIds, (LinkedHashMap<String, ActionLayoutData>)actionLayoutDataById);
            } else {
                FieldSet fieldSet = (FieldSet)fieldSetForUnreferencedActionsRef.get();
                if (fieldSet != null) {
                    this.addActionsTo(fieldSet, (List<String>)missingActionIds, (LinkedHashMap<String, ActionLayoutData>)actionLayoutDataById);
                }
            }
        }
        return true;
    }

    protected void addPropertiesTo(FieldSet fieldSet, List<String> propertyIds, LinkedHashMap<String, PropertyLayoutData> propertyLayoutDataById) {
        ImmutableList existingIds = FluentIterable.from((Iterable)fieldSet.getProperties()).transform((Function)new Function<PropertyLayoutData, String>(){

            @Nullable
            public String apply(@Nullable PropertyLayoutData propertyLayoutData) {
                return propertyLayoutData.getId();
            }
        }).toList();
        for (String propertyId : propertyIds) {
            if (existingIds.contains((Object)propertyId)) continue;
            PropertyLayoutData propertyLayoutData = new PropertyLayoutData(propertyId);
            fieldSet.getProperties().add(propertyLayoutData);
            propertyLayoutData.setOwner(fieldSet);
            propertyLayoutDataById.put(propertyId, propertyLayoutData);
        }
    }

    protected void addCollectionsTo(BS3Col tabRowCol, List<String> collectionIds, LinkedHashMap<String, CollectionLayoutData> collectionLayoutDataById) {
        for (String collectionId : collectionIds) {
            CollectionLayoutData collectionLayoutData = new CollectionLayoutData(collectionId);
            collectionLayoutData.setDefaultView("table");
            tabRowCol.getCollections().add(collectionLayoutData);
            collectionLayoutDataById.put(collectionId, collectionLayoutData);
        }
    }

    protected void addCollectionsTo(BS3TabGroup tabGroup, List<String> collectionIds, ObjectSpecification objectSpec) {
        for (String collectionId : collectionIds) {
            BS3Tab bs3Tab = new BS3Tab();
            bs3Tab.setName(objectSpec.getAssociation(collectionId).getName());
            tabGroup.getTabs().add(bs3Tab);
            bs3Tab.setOwner((BS3TabOwner)tabGroup);
            BS3Row tabRow = new BS3Row();
            tabRow.setOwner((BS3RowOwner)bs3Tab);
            bs3Tab.getRows().add(tabRow);
            BS3Col tabRowCol = new BS3Col();
            tabRowCol.setSpan(12);
            tabRowCol.setSize(Size.MD);
            tabRowCol.setOwner((BS3RowContentOwner)tabRow);
            tabRow.getCols().add(tabRowCol);
            CollectionLayoutData layoutMetadata = new CollectionLayoutData(collectionId);
            layoutMetadata.setDefaultView("table");
            tabRowCol.getCollections().add(layoutMetadata);
        }
    }

    protected void addActionsTo(BS3Col bs3Col, List<String> actionIds, LinkedHashMap<String, ActionLayoutData> actionLayoutDataById) {
        for (String actionId : actionIds) {
            ActionLayoutData actionLayoutData = new ActionLayoutData(actionId);
            this.addActionTo((ActionLayoutDataOwner)bs3Col, actionLayoutData);
            actionLayoutDataById.put(actionId, actionLayoutData);
        }
    }

    protected void addActionsTo(FieldSet fieldSet, List<String> actionIds, LinkedHashMap<String, ActionLayoutData> actionLayoutDataById) {
        for (String actionId : actionIds) {
            ActionLayoutData actionLayoutData = new ActionLayoutData(actionId);
            this.addActionTo((ActionLayoutDataOwner)fieldSet, actionLayoutData);
            actionLayoutDataById.put(actionId, actionLayoutData);
        }
    }

    protected void addActionTo(ActionLayoutDataOwner owner, ActionLayoutData actionLayoutData) {
        List actions = owner.getActions();
        if (actions == null) {
            actions = Lists.newArrayList();
            owner.setActions(actions);
        }
        actions.add(actionLayoutData);
        actionLayoutData.setOwner(owner);
    }

    private static Boolean isSet(Boolean flag) {
        return flag != null && flag != false;
    }

    private static String asId(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char c = str.charAt(0);
        return Character.toLowerCase(c) + str.substring(1).replaceAll("\\s+", "");
    }
}

