/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.Grid;
import org.apache.isis.applib.services.grid.GridService;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class LayoutServiceDefault
implements LayoutService {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutServiceDefault.class);
    @Inject
    SpecificationLoader specificationLoader;
    @Inject
    JaxbService jaxbService;
    @Inject
    GridService gridService;

    public String toXml(Class<?> domainClass, LayoutService.Style style) {
        Grid grid = this.toGrid(domainClass, style);
        return this.jaxbService.toXml((Object)grid, (Map)ImmutableMap.of((Object)"jaxb.schemaLocation", (Object)grid.getTnsAndSchemaLocation()));
    }

    protected Grid toGrid(Class<?> domainClass, LayoutService.Style style) {
        if (style == LayoutService.Style.CURRENT) {
            ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
            GridFacet facet = objectSpec.getFacet(GridFacet.class);
            return facet != null ? facet.getGrid() : null;
        }
        Grid grid = this.gridService.load(domainClass);
        if (grid == null) {
            grid = this.gridService.defaultGridFor(domainClass);
        }
        this.gridService.normalize(grid);
        if (style == LayoutService.Style.NORMALIZED) {
            return grid;
        }
        if (style == LayoutService.Style.COMPLETE) {
            return this.gridService.complete(grid);
        }
        if (style == LayoutService.Style.MINIMAL) {
            return this.gridService.minimal(grid);
        }
        throw new IllegalArgumentException("unsupported style");
    }

    @Programmatic
    public byte[] toZip(LayoutService.Style style) {
        byte[] bytes;
        Collection<ObjectSpecification> allSpecs = this.specificationLoader.allSpecifications();
        Collection domainObjectSpecs = Collections2.filter(allSpecs, (Predicate)new Predicate<ObjectSpecification>(){

            public boolean apply(ObjectSpecification input) {
                return !input.isAbstract() && (input.containsDoOpFacet(JdoPersistenceCapableFacet.class) || input.containsDoOpFacet(ViewModelFacet.class));
            }
        });
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            OutputStreamWriter writer = new OutputStreamWriter(zos);
            for (ObjectSpecification objectSpec : domainObjectSpecs) {
                Class<?> domainClass = objectSpec.getCorrespondingClass();
                Grid grid = this.toGrid(domainClass, style);
                if (grid == null) continue;
                zos.putNextEntry(new ZipEntry(LayoutServiceDefault.zipEntryNameFor(objectSpec)));
                String xml = this.jaxbService.toXml((Object)grid, (Map)ImmutableMap.of((Object)"jaxb.schemaLocation", (Object)grid.getTnsAndSchemaLocation()));
                writer.write(xml);
                writer.flush();
                zos.closeEntry();
            }
            writer.close();
            bytes = baos.toByteArray();
        }
        catch (IOException ex) {
            throw new FatalException("Unable to create zip of layouts", (Throwable)ex);
        }
        return bytes;
    }

    private static String zipEntryNameFor(ObjectSpecification objectSpec) {
        String fqn = objectSpec.getFullIdentifier();
        return fqn.replace(".", File.separator) + ".layout.xml";
    }
}

