/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.message;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.core.metamodel.services.msgbroker.MessageBrokerServiceInternal;

@DomainService(nature=NatureOfService.DOMAIN)
public class MessageServiceInternalDefault
implements MessageService {
    @Inject
    MessageBrokerServiceInternal messageBrokerServiceInternal;
    @Inject
    TranslationService translationService;

    @Programmatic
    public void informUser(String message) {
        this.messageBrokerServiceInternal.informUser(message);
    }

    public String informUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return message.translate(this.translationService, MessageServiceInternalDefault.context(contextClass, contextMethod));
    }

    @Programmatic
    public void warnUser(String message) {
        this.messageBrokerServiceInternal.warnUser(message);
    }

    public String warnUser(TranslatableString message, Class<?> contextClass, String contextMethod) {
        return message.translate(this.translationService, MessageServiceInternalDefault.context(contextClass, contextMethod));
    }

    @Programmatic
    public void raiseError(String message) {
        this.messageBrokerServiceInternal.raiseError(message);
    }

    public String raiseError(TranslatableString message, Class<?> contextClass, String contextMethod) {
        String translatedMessage = message.translate(this.translationService, MessageServiceInternalDefault.context(contextClass, contextMethod));
        this.messageBrokerServiceInternal.raiseError(translatedMessage);
        return translatedMessage;
    }

    private static String context(Class<?> contextClass, String contextMethod) {
        return contextClass.getName() + "#" + contextMethod;
    }
}

