/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.metamodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.grid.GridService;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.applib.services.metamodel.MetaModelService2;
import org.apache.isis.applib.services.metamodel.MetaModelService3;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.services.metamodel.DomainMemberDefault;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.datanucleus.enhancement.Persistable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class MetaModelServiceDefault
implements MetaModelService3 {
    private static final Logger LOG = LoggerFactory.getLogger(MetaModelServiceDefault.class);
    @Inject
    SpecificationLoader specificationLookup;
    @Inject
    GridService gridService;

    @Programmatic
    public Class<?> fromObjectType(String objectType) {
        if (objectType == null) {
            return null;
        }
        ObjectSpecId objectSpecId = new ObjectSpecId(objectType);
        ObjectSpecification objectSpecification = this.specificationLookup.lookupBySpecId(objectSpecId);
        return objectSpecification != null ? objectSpecification.getCorrespondingClass() : null;
    }

    public String toObjectType(Class<?> domainType) {
        if (domainType == null) {
            return null;
        }
        ObjectSpecification objectSpecification = this.specificationLookup.loadSpecification(domainType);
        ObjectSpecIdFacet objectSpecIdFacet = objectSpecification.getFacet(ObjectSpecIdFacet.class);
        ObjectSpecId objectSpecId = objectSpecIdFacet.value();
        return objectSpecId.asString();
    }

    public void rebuild(Class<?> domainType) {
        this.specificationLookup.invalidateCache(domainType);
        this.gridService.remove(domainType);
        ObjectSpecification objectSpecification = this.specificationLookup.loadSpecification(domainType);
        objectSpecification.getObjectActions(Contributed.INCLUDED);
        objectSpecification.getAssociations(Contributed.INCLUDED);
    }

    @Programmatic
    public List<DomainMember> export() {
        Collection<ObjectSpecification> specifications = this.specificationLookup.allSpecifications();
        ArrayList rows = Lists.newArrayList();
        for (ObjectSpecification spec : specifications) {
            if (this.exclude(spec)) continue;
            List<ObjectAssociation> properties = spec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES);
            for (ObjectAssociation property : properties) {
                OneToOneAssociation otoa = (OneToOneAssociation)property;
                if (this.exclude(otoa)) continue;
                rows.add(new DomainMemberDefault(spec, otoa));
            }
            List<ObjectAssociation> associations = spec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.COLLECTIONS);
            for (ObjectAssociation collection : associations) {
                OneToManyAssociation otma = (OneToManyAssociation)collection;
                if (this.exclude(otma)) continue;
                rows.add(new DomainMemberDefault(spec, otma));
            }
            List<ObjectAction> actions = spec.getObjectActions(Contributed.INCLUDED);
            for (ObjectAction action : actions) {
                if (this.exclude(action)) continue;
                rows.add(new DomainMemberDefault(spec, action));
            }
        }
        Collections.sort(rows);
        return rows;
    }

    protected boolean exclude(OneToOneAssociation property) {
        return false;
    }

    protected boolean exclude(OneToManyAssociation collection) {
        return false;
    }

    protected boolean exclude(ObjectAction action) {
        return false;
    }

    protected boolean exclude(ObjectSpecification spec) {
        return this.isBuiltIn(spec) || spec.isAbstract();
    }

    protected boolean isBuiltIn(ObjectSpecification spec) {
        String className = spec.getFullIdentifier();
        return className.startsWith("java") || className.startsWith("org.joda");
    }

    public MetaModelService2.Sort sortOf(Class<?> domainType) {
        return this.sortOf(domainType, MetaModelService3.Mode.STRICT);
    }

    public MetaModelService2.Sort sortOf(Class<?> domainType, MetaModelService3.Mode mode) {
        if (domainType == null) {
            return null;
        }
        ObjectSpecification objectSpec = this.specificationLookup.loadSpecification(domainType);
        if (objectSpec.isService()) {
            return MetaModelService2.Sort.DOMAIN_SERVICE;
        }
        if (objectSpec.isViewModel()) {
            return MetaModelService2.Sort.VIEW_MODEL;
        }
        if (objectSpec.isValue()) {
            return MetaModelService2.Sort.VALUE;
        }
        if (objectSpec.isMixin()) {
            return MetaModelService2.Sort.VALUE;
        }
        if (objectSpec.isParentedOrFreeCollection()) {
            return MetaModelService2.Sort.COLLECTION;
        }
        Class<?> correspondingClass = objectSpec.getCorrespondingClass();
        if (Persistable.class.isAssignableFrom(correspondingClass)) {
            return MetaModelService2.Sort.JDO_ENTITY;
        }
        if (mode == MetaModelService3.Mode.RELAXED) {
            return MetaModelService2.Sort.UNKNOWN;
        }
        throw new IllegalArgumentException(String.format("Unable to determine what sort of domain object is '%s'", objectSpec.getFullIdentifier()));
    }

    public MetaModelService2.Sort sortOf(Bookmark bookmark) {
        return this.sortOf(bookmark, MetaModelService3.Mode.STRICT);
    }

    public MetaModelService2.Sort sortOf(Bookmark bookmark, MetaModelService3.Mode mode) {
        if (bookmark == null) {
            return null;
        }
        Class<?> domainType = this.fromObjectType(bookmark.getObjectType());
        return this.sortOf(domainType, mode);
    }
}

