/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.registry;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.registry.ServiceRegistry2;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;

@DomainService(nature=NatureOfService.DOMAIN)
public class ServiceRegistryDefault
implements ServiceRegistry2,
ServicesInjectorAware {
    @Inject
    WrapperFactory wrapperFactory;
    private ServicesInjector servicesInjector;

    @Programmatic
    public <T> T injectServicesInto(T domainObject) {
        this.servicesInjector.injectServicesInto(this.unwrapped(domainObject));
        return domainObject;
    }

    @Programmatic
    public <T> T lookupService(Class<T> service) {
        return this.servicesInjector.lookupService(service);
    }

    @Programmatic
    public <T> Iterable<T> lookupServices(Class<T> service) {
        return this.servicesInjector.lookupServices(service);
    }

    @Programmatic
    public List<Object> getRegisteredServices() {
        return this.servicesInjector.getRegisteredServices();
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

