/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.core.metamodel.services.swagger.internal.SwaggerSpecGenerator;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class SwaggerServiceDefault
implements SwaggerService {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerServiceDefault.class);
    public static final String KEY_RESTFUL_BASE_PATH = "isis.services.swagger.restfulBasePath";
    public static final String KEY_RESTFUL_BASE_PATH_DEFAULT = "/restful";
    private String basePath;
    @Inject
    SpecificationLoader specificationLoader;

    @PostConstruct
    public void init(Map<String, String> properties) {
        this.basePath = SwaggerServiceDefault.getPropertyElse(properties, KEY_RESTFUL_BASE_PATH, KEY_RESTFUL_BASE_PATH_DEFAULT);
    }

    static String getPropertyElse(Map<String, String> properties, String key, String dflt) {
        String basePath = properties.get(key);
        if (basePath == null) {
            basePath = dflt;
        }
        return basePath;
    }

    @Programmatic
    public String generateSwaggerSpec(SwaggerService.Visibility visibility, SwaggerService.Format format) {
        SwaggerSpecGenerator swaggerSpecGenerator = new SwaggerSpecGenerator(this.specificationLoader);
        String swaggerSpec = swaggerSpecGenerator.generate(this.basePath, visibility, format);
        return swaggerSpec;
    }
}

