/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Tagger {
    static Pattern tagPatternIsisAddons = Pattern.compile("^org\\.isisaddons\\.module\\.([^\\.]+)\\.(.+)$");
    static Pattern tagPatternForFqcn = Pattern.compile("^.*\\.([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForSchemaTable = Pattern.compile("^([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForJaxbDto = Pattern.compile("^.*\\.([^\\.]+)\\.(v[0-9][^\\.]*)\\.([^\\.]+)$");

    Tagger() {
    }

    String tagFor(String str, String fallback) {
        if (str.startsWith("org.apache.isis")) {
            return "> apache isis internals";
        }
        Matcher matcher = tagPatternIsisAddons.matcher(str);
        if (matcher.matches()) {
            return "isisaddons " + matcher.group(1);
        }
        matcher = tagPatternForJaxbDto.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForFqcn.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForSchemaTable.matcher(str);
        if (matcher.matches()) {
            if (str.startsWith("isis")) {
                return "isisaddons " + str.substring(4, str.indexOf("."));
            }
            return matcher.group(1);
        }
        return fallback != null ? fallback : str;
    }
}

