/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import io.swagger.models.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.services.swagger.internal.Caching;
import org.apache.isis.core.metamodel.services.swagger.internal.ClassExcluder;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public final class Util {
    private Util() {
    }

    static boolean isVisibleForPublic(ObjectAction objectAction) {
        ObjectSpecification elementSpec;
        TypeOfFacet typeOfFacet;
        ObjectSpecification specification = objectAction.getReturnType();
        boolean visible = Util.isVisibleForPublic(specification);
        if (!visible && (typeOfFacet = objectAction.getFacet(TypeOfFacet.class)) != null && !Util.isVisibleForPublic(elementSpec = typeOfFacet.valueSpec())) {
            return false;
        }
        List<ObjectSpecification> parameterTypes = objectAction.getParameterTypes();
        for (ObjectSpecification parameterType : parameterTypes) {
            boolean paramVisible = Util.isVisibleForPublic(parameterType);
            if (paramVisible) continue;
            return false;
        }
        return true;
    }

    static boolean isVisibleForPublic(ObjectAssociation objectAssociation) {
        ObjectSpecification specification = objectAssociation.getSpecification();
        return Util.isVisibleForPublic(specification);
    }

    static boolean isVisibleForPublic(ObjectSpecification specification) {
        TypeOfFacet typeOfFacet;
        if (specification == null) {
            return true;
        }
        if (specification.isViewModel()) {
            return true;
        }
        if (specification.isValue()) {
            return true;
        }
        if (specification.isParentedOrFreeCollection() && (typeOfFacet = specification.getFacet(TypeOfFacet.class)) != null) {
            ObjectSpecification elementSpec = typeOfFacet.valueSpec();
            return Util.isVisibleForPublic(elementSpec);
        }
        Class<?> correspondingClass = specification.getCorrespondingClass();
        return Collection.class.isAssignableFrom(correspondingClass) || correspondingClass.isArray() || correspondingClass == Void.TYPE || correspondingClass == Void.class;
    }

    static Filter<ObjectAssociation> associationsWith(final SwaggerService.Visibility visibility) {
        return new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation objectAssociation) {
                return !visibility.isPublic() || Util.isVisibleForPublic(objectAssociation);
            }
        };
    }

    static List<OneToOneAssociation> propertiesOf(ObjectSpecification objectSpecification, SwaggerService.Visibility visibility) {
        return Util.associationsOf(objectSpecification, ObjectAssociation.Filters.PROPERTIES, visibility);
    }

    static List<OneToManyAssociation> collectionsOf(ObjectSpecification objectSpecification, SwaggerService.Visibility visibility) {
        return Util.associationsOf(objectSpecification, ObjectAssociation.Filters.COLLECTIONS, visibility);
    }

    static <T extends ObjectAssociation> List<T> associationsOf(ObjectSpecification objectSpecification, Filter<ObjectAssociation> associationFilter, SwaggerService.Visibility visibility) {
        List<ObjectAssociation> list = objectSpecification.getAssociations(Contributed.INCLUDED, (Filter<ObjectAssociation>)Filters.and((Filter[])new Filter[]{associationFilter, Util.associationsWith(visibility)}));
        return Util.cast(list);
    }

    static <T> List<T> cast(List list) {
        return list;
    }

    static List<ObjectAction> actionsOf(ObjectSpecification objectSpec, final SwaggerService.Visibility visibility, final ClassExcluder classExcluder) {
        List<ActionType> actionTypes = Util.actionTypesFor(visibility);
        return objectSpec.getObjectActions(actionTypes, Contributed.INCLUDED, new Filter<ObjectAction>(){

            public boolean accept(ObjectAction objectAction) {
                return !classExcluder.exclude(objectAction) && !visibility.isPublic() || Util.isVisibleForPublic(objectAction);
            }
        });
    }

    static String roSpec(String section) {
        return "RO Spec v1.0, section " + section;
    }

    static Response withCachingHeaders(Response response, Caching caching) {
        caching.withHeaders(response);
        return response;
    }

    static List<ActionType> actionTypesFor(SwaggerService.Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return Arrays.asList(ActionType.USER);
            }
            case PRIVATE: {
                return Arrays.asList(ActionType.USER);
            }
            case PRIVATE_WITH_PROTOTYPING: {
                return Arrays.asList(ActionType.USER, ActionType.PROTOTYPE);
            }
        }
        throw new IllegalArgumentException("Unrecognized type '" + visibility + "'");
    }
}

