/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.security.RoleMemento;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.applib.services.sudo.SudoService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;

@DomainService(nature=NatureOfService.DOMAIN)
public class UserServiceDefault
implements UserService {
    private final ThreadLocal<Stack<UserAndRoleOverrides>> overrides = new ThreadLocal<Stack<UserAndRoleOverrides>>(){

        @Override
        protected Stack<UserAndRoleOverrides> initialValue() {
            return new Stack<UserAndRoleOverrides>();
        }
    };
    @Inject
    AuthenticationSessionProvider authenticationSessionProvider;

    @Programmatic
    public UserMemento getUser() {
        UserAndRoleOverrides userAndRoleOverrides = this.currentOverridesIfAny();
        if (userAndRoleOverrides != null) {
            String username = userAndRoleOverrides.user;
            List<String> roles = userAndRoleOverrides.roles != null ? userAndRoleOverrides.roles : this.previousRoles();
            List<RoleMemento> roleMementos = UserServiceDefault.asRoleMementos(roles);
            return new UserMemento(username, roleMementos);
        }
        AuthenticationSession session = this.authenticationSessionProvider.getAuthenticationSession();
        return session.createUserMemento();
    }

    private List<String> previousRoles() {
        AuthenticationSession session = this.authenticationSessionProvider.getAuthenticationSession();
        List<String> roles = session.getRoles();
        return roles;
    }

    private void overrideUserAndRoles(String user, List<String> rolesIfAny) {
        List<String> roles = rolesIfAny != null ? rolesIfAny : this.inheritRoles();
        this.overrides.get().push(new UserAndRoleOverrides(user, roles));
    }

    private void resetOverrides() {
        this.overrides.get().pop();
    }

    public UserAndRoleOverrides currentOverridesIfAny() {
        Stack<UserAndRoleOverrides> userAndRoleOverrides = this.overrides.get();
        return !userAndRoleOverrides.empty() ? userAndRoleOverrides.peek() : null;
    }

    private List<String> inheritRoles() {
        UserAndRoleOverrides currentOverridesIfAny = this.currentOverridesIfAny();
        return currentOverridesIfAny != null ? currentOverridesIfAny.getRoles() : this.authenticationSessionProvider.getAuthenticationSession().getRoles();
    }

    private static List<RoleMemento> asRoleMementos(List<String> roles) {
        ArrayList<RoleMemento> mementos = new ArrayList<RoleMemento>();
        if (roles != null) {
            for (String role : roles) {
                mementos.add(new RoleMemento(role));
            }
        }
        return mementos;
    }

    @DomainService(nature=NatureOfService.DOMAIN)
    public static class SudoServiceSpi
    implements SudoService.Spi {
        @Inject
        UserServiceDefault userServiceDefault;

        public void runAs(String username, List<String> roles) {
            this.userServiceDefault.overrideUserAndRoles(username, roles);
        }

        public void releaseRunAs() {
            this.userServiceDefault.resetOverrides();
        }
    }

    public static class UserAndRoleOverrides {
        final String user;
        final List<String> roles;

        UserAndRoleOverrides(String user) {
            this(user, null);
        }

        UserAndRoleOverrides(String user, List<String> roles) {
            this.user = user;
            this.roles = roles;
        }

        public String getUser() {
            return this.user;
        }

        public List<String> getRoles() {
            return this.roles;
        }
    }
}

