/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.spec.DefaultProvider;
import org.apache.isis.core.metamodel.spec.Hierarchical;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.Persistability;
import org.apache.isis.core.metamodel.spec.Specification;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionContainer;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociationContainer;

public interface ObjectSpecification
extends Specification,
ObjectActionContainer,
ObjectAssociationContainer,
Hierarchical,
DefaultProvider {
    public static final List<ObjectSpecification> EMPTY_LIST = Collections.emptyList();
    public static final Function<ObjectSpecification, String> FUNCTION_FULLY_QUALIFIED_CLASS_NAME = new Function<ObjectSpecification, String>(){

        public String apply(ObjectSpecification from) {
            return from.getFullIdentifier();
        }
    };
    public static final Comparator<ObjectSpecification> COMPARATOR_FULLY_QUALIFIED_CLASS_NAME = new Comparator<ObjectSpecification>(){

        @Override
        public int compare(ObjectSpecification o1, ObjectSpecification o2) {
            return o1.getFullIdentifier().compareTo(o2.getFullIdentifier());
        }
    };
    public static final Comparator<ObjectSpecification> COMPARATOR_SHORT_IDENTIFIER_IGNORE_CASE = new Comparator<ObjectSpecification>(){

        @Override
        public int compare(ObjectSpecification s1, ObjectSpecification s2) {
            return s1.getShortIdentifier().compareToIgnoreCase(s2.getShortIdentifier());
        }
    };

    public Class<?> getCorrespondingClass();

    public ObjectSpecId getSpecId();

    public String getFullIdentifier();

    public String getShortIdentifier();

    public String getSingularName();

    public String getPluralName();

    @Override
    public String getDescription();

    public String getHelp();

    @Deprecated
    public String getTitle(ObjectAdapter var1);

    public String getTitle(ObjectAdapter var1, ObjectAdapter var2);

    public String getIconName(ObjectAdapter var1);

    @Deprecated
    public String getCssClass();

    public String getCssClass(ObjectAdapter var1);

    public boolean isAbstract();

    public ObjectTitleContext createTitleInteractionContext(AuthenticationSession var1, InteractionInitiatedBy var2, ObjectAdapter var3);

    public ObjectValidityContext createValidityInteractionContext(ObjectAdapter var1, InteractionInitiatedBy var2);

    public Consent isValid(ObjectAdapter var1, InteractionInitiatedBy var2);

    public InteractionResult isValidResult(ObjectAdapter var1, InteractionInitiatedBy var2);

    public Persistability persistability();

    public boolean isNotCollection();

    public boolean isParentedOrFreeCollection();

    public boolean isValue();

    public boolean isParented();

    public boolean isValueOrIsParented();

    public boolean isParseable();

    public boolean isEncodeable();

    public boolean isImmutable();

    public boolean isHidden();

    public boolean isService();

    public boolean isViewModel();

    public boolean isMixin();

    public boolean isViewModelCloneable(ObjectAdapter var1);

    public boolean isWizard();
}

