/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.commons.lang.StringFunctions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetFilters;
import org.apache.isis.core.metamodel.facets.actions.bulk.BulkFacet;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.wizard.WizardFacet;
import org.apache.isis.core.metamodel.interactions.ValidatingInteractionAdvisor;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;

public interface ObjectAction
extends ObjectMember {
    public ActionSemantics.Of getSemantics();

    public ObjectSpecification getOnType();

    public ActionType getType();

    public boolean isPrototype();

    public ObjectSpecification getReturnType();

    public boolean hasReturn();

    public ObjectAdapter executeWithRuleChecking(ObjectAdapter var1, ObjectAdapter var2, ObjectAdapter[] var3, InteractionInitiatedBy var4, Where var5) throws ObjectMember.AuthorizationException;

    public ObjectAdapter execute(ObjectAdapter var1, ObjectAdapter var2, ObjectAdapter[] var3, InteractionInitiatedBy var4);

    public Consent isProposedArgumentSetValid(ObjectAdapter var1, ObjectAdapter[] var2, InteractionInitiatedBy var3);

    public int getParameterCount();

    public List<ObjectActionParameter> getParameters();

    public List<ObjectSpecification> getParameterTypes();

    public List<ObjectActionParameter> getParameters(Filter<ObjectActionParameter> var1);

    public ObjectActionParameter getParameterById(String var1);

    public ObjectActionParameter getParameterByName(String var1);

    public ObjectAdapter[] getDefaults(ObjectAdapter var1);

    public ObjectAdapter[][] getChoices(ObjectAdapter var1, InteractionInitiatedBy var2);

    public void setupBulkActionInvocationContext(ObjectAdapter var1);

    public static final class Filters {
        private Filters() {
        }

        @Deprecated
        public static Filter<ObjectAction> dynamicallyVisible(final ObjectAdapter target, final InteractionInitiatedBy interactionInitiatedBy, final Where where) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction objectAction) {
                    Consent visible = objectAction.isVisible(target, interactionInitiatedBy, where);
                    return visible.isAllowed();
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> withId(final String actionId) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction objectAction) {
                    return objectAction.getId().equals(actionId);
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> withNoValidationRules() {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction objectAction) {
                    List<Facet> validatingFacets = objectAction.getFacets(FacetFilters.isA(ValidatingInteractionAdvisor.class));
                    return validatingFacets.isEmpty();
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> ofType(final ActionType type) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction oa) {
                    return oa.getType() == type;
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> bulk() {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction oa) {
                    Class<?> returnType;
                    BulkFacet bulkFacet = oa.getFacet(BulkFacet.class);
                    if (bulkFacet == null || bulkFacet.isNoop() || bulkFacet.value() == Bulk.AppliesTo.REGULAR_ONLY) {
                        return false;
                    }
                    if (oa.getParameterCount() != 0) {
                        return false;
                    }
                    ObjectSpecification returnSpec = oa.getReturnType();
                    return returnSpec == null || (returnType = returnSpec.getCorrespondingClass()) != Blob.class && returnType != Clob.class;
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> notBulkOnly() {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction t) {
                    BulkFacet facet = t.getFacet(BulkFacet.class);
                    return facet == null || facet.value() != Bulk.AppliesTo.BULK_ONLY;
                }
            };
        }

        public static Filter<ObjectAction> excludeWizardActions(ObjectSpecification objectSpecification) {
            return org.apache.isis.applib.filter.Filters.not(Filters.wizardActions(objectSpecification));
        }

        private static Filter<ObjectAction> wizardActions(final ObjectSpecification objectSpecification) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction input) {
                    if (objectSpecification == null) {
                        return false;
                    }
                    WizardFacet wizardFacet = objectSpecification.getFacet(WizardFacet.class);
                    return wizardFacet != null && wizardFacet.isWizardAction(input);
                }
            };
        }

        public static Filter<ObjectAction> memberOrderOf(ObjectAssociation association) {
            final String assocName = association.getName();
            final String assocId = association.getId();
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction t) {
                    MemberOrderFacet memberOrderFacet = t.getFacet(MemberOrderFacet.class);
                    if (memberOrderFacet == null || Strings.isNullOrEmpty((String)memberOrderFacet.name())) {
                        return false;
                    }
                    String memberOrderName = memberOrderFacet.name().toLowerCase();
                    if (Strings.isNullOrEmpty((String)memberOrderName)) {
                        return false;
                    }
                    return memberOrderName.equalsIgnoreCase(assocName) || memberOrderName.equalsIgnoreCase(assocId);
                }
            };
        }

        public static Filter<ObjectAction> memberOrderNotAssociationOf(ObjectSpecification adapterSpec) {
            List<ObjectAssociation> associations = adapterSpec.getAssociations(Contributed.INCLUDED);
            final List associationNames = Lists.transform(associations, (Function)Functions.compose(StringFunctions.toLowerCase(), ObjectAssociation.Functions.toName()));
            final List associationIds = Lists.transform(associations, (Function)Functions.compose(StringFunctions.toLowerCase(), ObjectAssociation.Functions.toId()));
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction t) {
                    MemberOrderFacet memberOrderFacet = t.getFacet(MemberOrderFacet.class);
                    if (memberOrderFacet == null || Strings.isNullOrEmpty((String)memberOrderFacet.name())) {
                        return true;
                    }
                    String memberOrderName = memberOrderFacet.name().toLowerCase();
                    if (Strings.isNullOrEmpty((String)memberOrderName)) {
                        return false;
                    }
                    return !associationNames.contains(memberOrderName) && !associationIds.contains(memberOrderName);
                }
            };
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        public static Predicate<ObjectAction> dynamicallyVisible(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.dynamicallyVisible(target, interactionInitiatedBy, where));
        }

        public static Predicate<ObjectAction> withId(String actionId) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.withId(actionId));
        }

        public static Predicate<ObjectAction> withNoValidationRules() {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.withNoValidationRules());
        }

        public static Predicate<ObjectAction> ofType(ActionType type) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.ofType(type));
        }

        public static Predicate<ObjectAction> bulk() {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.bulk());
        }

        public static Predicate<ObjectAction> notBulkOnly() {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.notBulkOnly());
        }

        public static Predicate<ObjectAction> memberOrderOf(ObjectAssociation association) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.memberOrderOf(association));
        }
    }

    public static final class Utils {
        private Utils() {
        }

        public static String nameFor(ObjectAction objAction) {
            String actionName = objAction.getName();
            if (actionName != null) {
                return actionName;
            }
            NamedFacet namedFacet = objAction.getFacet(NamedFacet.class);
            if (namedFacet != null) {
                return namedFacet.value();
            }
            return "(no name)";
        }

        public static boolean returnsBlobOrClob(ObjectAction objectAction) {
            Class<?> cls;
            boolean blobOrClob = false;
            ObjectSpecification returnType = objectAction.getReturnType();
            if (returnType != null && (Blob.class.isAssignableFrom(cls = returnType.getCorrespondingClass()) || Clob.class.isAssignableFrom(cls))) {
                blobOrClob = true;
            }
            return blobOrClob;
        }

        public static String actionIdentifierFor(ObjectAction action) {
            Identifier identifier = action.getIdentifier();
            String className = action.getOnType().getShortIdentifier();
            String actionId = action.getId();
            return className + "-" + actionId;
        }

        public static String descriptionOf(ObjectAction action) {
            return action.getDescription();
        }

        public static ActionLayout.Position actionLayoutPositionOf(ObjectAction action) {
            ActionPositionFacet layoutFacet = action.getFacet(ActionPositionFacet.class);
            return layoutFacet != null ? layoutFacet.position() : ActionLayout.Position.BELOW;
        }

        public static String cssClassFaFor(ObjectAction action) {
            CssClassFaFacet cssClassFaFacet = action.getFacet(CssClassFaFacet.class);
            return cssClassFaFacet != null ? cssClassFaFacet.value() : null;
        }

        public static CssClassFaPosition cssClassFaPositionFor(ObjectAction action) {
            CssClassFaFacet facet = action.getFacet(CssClassFaFacet.class);
            return facet != null ? facet.getPosition() : CssClassFaPosition.LEFT;
        }

        public static String cssClassFor(ObjectAction action, ObjectAdapter objectAdapter) {
            CssClassFacet cssClassFacet = action.getFacet(CssClassFacet.class);
            return cssClassFacet != null ? cssClassFacet.cssClass(objectAdapter) : null;
        }
    }
}

