/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Function;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.interactions.ActionArgValidityContext;
import org.apache.isis.core.metamodel.spec.feature.CurrentHolder;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;

public interface ObjectActionParameter
extends ObjectFeature,
CurrentHolder {
    public ObjectAction getAction();

    public boolean isOptional();

    public int getNumber();

    @Override
    public String getName();

    public ActionArgValidityContext createProposedArgumentInteractionContext(ObjectAdapter var1, ObjectAdapter[] var2, int var3, InteractionInitiatedBy var4);

    public boolean hasAutoComplete();

    public ObjectAdapter[] getAutoComplete(ObjectAdapter var1, String var2, InteractionInitiatedBy var3);

    public int getAutoCompleteMinLength();

    public boolean hasChoices();

    public ObjectAdapter[] getChoices(ObjectAdapter var1, ObjectAdapter[] var2, InteractionInitiatedBy var3);

    public ObjectAdapter getDefault(ObjectAdapter var1);

    public String isValid(ObjectAdapter var1, Object var2, InteractionInitiatedBy var3);

    public static class Functions {
        public static final Function<ObjectActionParameter, String> GET_NAME = new Function<ObjectActionParameter, String>(){

            public String apply(ObjectActionParameter input) {
                return input.getName();
            }
        };
        public static final Function<ObjectActionParameter, Class<?>> GET_TYPE = new Function<ObjectActionParameter, Class<?>>(){

            public Class<?> apply(ObjectActionParameter input) {
                return input.getSpecification().getCorrespondingClass();
            }
        };

        private Functions() {
        }
    }

    public static class Filters {
        public static final Filter<ObjectActionParameter> PARAMETER_ASSOCIATIONS = new Filter<ObjectActionParameter>(){

            public boolean accept(ObjectActionParameter parameter) {
                return parameter.getSpecification().isNotCollection();
            }
        };

        private Filters() {
        }
    }
}

