/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.util.DeweyOrderComparator;

public interface ObjectMember
extends ObjectFeature {
    public String getHelp();

    public boolean isAlwaysHidden();

    public Consent isVisible(ObjectAdapter var1, InteractionInitiatedBy var2, Where var3);

    public Consent isUsable(ObjectAdapter var1, InteractionInitiatedBy var2, Where var3);

    public boolean isPropertyOrCollection();

    public boolean isOneToManyAssociation();

    public boolean isOneToOneAssociation();

    public boolean isAction();

    public static class Comparators {
        public static Comparator<ObjectMember> byMemberOrderSequence() {
            return new Comparator<ObjectMember>(){
                private final DeweyOrderComparator deweyOrderComparator = new DeweyOrderComparator();

                @Override
                public int compare(ObjectMember o1, ObjectMember o2) {
                    String o2Sequence;
                    MemberOrderFacet o1Facet = o1.getFacet(MemberOrderFacet.class);
                    MemberOrderFacet o2Facet = o2.getFacet(MemberOrderFacet.class);
                    String memberId1 = o1.getId();
                    String memberId2 = o2.getId();
                    String o1Sequence = o1Facet != null ? o1Facet.sequence() : "0";
                    String string = o2Sequence = o2Facet != null ? o2Facet.sequence() : "0";
                    return o1Facet == null ? 1 : (o2Facet == null ? -1 : this.deweyOrderComparator.compare(o1Sequence, o2Sequence));
                }
            };
        }
    }

    public static class Util {
        private Util() {
        }

        public static <T extends ObjectMember> HashMap<String, T> mapById(List<T> members) {
            LinkedHashMap memberById = Maps.newLinkedHashMap();
            for (ObjectMember member : members) {
                String id = (String)Functions.getId().apply((Object)member);
                memberById.put(id, member);
            }
            return memberById;
        }
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectMember, String> getId() {
            return new Function<ObjectMember, String>(){

                @Nullable
                public String apply(@Nullable ObjectMember oneToOneAssociation) {
                    return oneToOneAssociation.getId();
                }
            };
        }
    }

    public static class AuthorizationException
    extends RuntimeException {
        public AuthorizationException() {
            this((RuntimeException)null);
        }

        public AuthorizationException(RuntimeException ex) {
            super("Not authorized or no such object", ex);
        }
    }
}

