/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

class SpecificationCacheDefault {
    private final Map<String, ObjectSpecification> specByClassName = Maps.newHashMap();
    private Map<ObjectSpecId, String> classNameBySpecId;

    SpecificationCacheDefault() {
    }

    public ObjectSpecification get(String className) {
        return this.specByClassName.get(className);
    }

    public void cache(String className, ObjectSpecification spec) {
        this.specByClassName.put(className, spec);
        this.recache(spec);
    }

    public void clear() {
        this.specByClassName.clear();
    }

    public Collection<ObjectSpecification> allSpecifications() {
        return Collections.unmodifiableCollection(this.specByClassName.values());
    }

    public ObjectSpecification getByObjectType(ObjectSpecId objectSpecID) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("SpecificationCache by object type has not yet been initialized");
        }
        String className = this.classNameBySpecId.get(objectSpecID);
        return className != null ? this.specByClassName.get(className) : null;
    }

    void setCacheBySpecId(Map<ObjectSpecId, ObjectSpecification> specById) {
        this.classNameBySpecId = Maps.newHashMap();
        for (ObjectSpecId objectSpecId : specById.keySet()) {
            ObjectSpecification objectSpec = specById.get(objectSpecId);
            String className = objectSpec.getCorrespondingClass().getName();
            this.classNameBySpecId.put(objectSpecId, className);
            this.specByClassName.put(className, objectSpec);
        }
    }

    public ObjectSpecification remove(String typeName) {
        ObjectSpecification removed = this.specByClassName.remove(typeName);
        if (removed != null && removed.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            ObjectSpecId specId = removed.getSpecId();
            this.classNameBySpecId.remove(specId);
        }
        return removed;
    }

    public void recache(ObjectSpecification spec) {
        if (!this.isInitialized()) {
            return;
        }
        if (!spec.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            return;
        }
        this.classNameBySpecId.put(spec.getSpecId(), spec.getCorrespondingClass().getName());
    }

    boolean isInitialized() {
        return this.classNameBySpecId != null;
    }
}

