/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationCacheDefault;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.standalonelist.ObjectSpecificationOnStandaloneList;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationLoader
implements ApplicationScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificationLoader.class);
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();
    private final ProgrammingModel programmingModel;
    private final FacetProcessor facetProcessor;
    private final ServicesInjector servicesInjector;
    private final MetaModelValidator metaModelValidator;
    private final SpecificationCacheDefault cache = new SpecificationCacheDefault();
    private final List<LayoutMetadataReader> layoutMetadataReaders;
    private boolean initialized = false;
    private ValidationFailures validationFailures;

    public SpecificationLoader(ProgrammingModel programmingModel, MetaModelValidator metaModelValidator, List<LayoutMetadataReader> layoutMetadataReaders, ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
        this.programmingModel = programmingModel;
        this.metaModelValidator = metaModelValidator;
        this.facetProcessor = new FacetProcessor(programmingModel);
        this.layoutMetadataReaders = layoutMetadataReaders;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info("finalizing reflector factory " + this);
    }

    @Programmatic
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialising {}", (Object)this);
        }
        this.facetProcessor.setServicesInjector(this.servicesInjector);
        for (LayoutMetadataReader layoutMetadataReader : this.layoutMetadataReaders) {
            this.servicesInjector.injectInto(layoutMetadataReader);
        }
        this.programmingModel.init();
        this.facetProcessor.init();
        this.metaModelValidator.init(this);
        this.loadSpecificationsForServices();
        this.loadSpecificationsForMixins();
        this.cacheBySpecId();
        this.initialized = true;
    }

    private void loadSpecificationsForServices() {
        for (Class<?> serviceClass : this.allServiceClasses()) {
            DomainService domainService = serviceClass.getAnnotation(DomainService.class);
            NatureOfService nature = domainService != null ? domainService.nature() : NatureOfService.DOMAIN;
            this.internalLoadSpecification(serviceClass, nature);
        }
    }

    private void loadSpecificationsForMixins() {
        Set mixinTypes = AppManifest.Registry.instance().getMixinTypes();
        if (mixinTypes == null) {
            return;
        }
        for (Class mixinType : mixinTypes) {
            this.internalLoadSpecification(mixinType);
        }
    }

    private void cacheBySpecId() {
        HashMap specById = Maps.newHashMap();
        for (ObjectSpecification objSpec : this.allSpecifications()) {
            ObjectSpecId objectSpecId = objSpec.getSpecId();
            if (objectSpecId == null) continue;
            specById.put(objectSpecId, objSpec);
        }
        this.cache.setCacheBySpecId(specById);
    }

    @Programmatic
    public boolean isInitialized() {
        return this.initialized;
    }

    @Programmatic
    public void shutdown() {
        LOG.info("shutting down " + this);
        this.initialized = false;
        this.cache.clear();
    }

    @Programmatic
    public void invalidateCache(Class<?> cls) {
        if (!this.cache.isInitialized()) {
            return;
        }
        Class<?> substitutedType = this.classSubstitutor.getClass(cls);
        if (substitutedType.isAnonymousClass()) {
            return;
        }
        for (ObjectSpecification spec = this.loadSpecification(substitutedType); spec != null; spec = spec.superclass()) {
            Class<?> type = spec.getCorrespondingClass();
            this.cache.remove(type.getName());
            if (!spec.containsDoOpFacet(ObjectSpecIdFacet.class)) continue;
            this.recache(spec);
        }
    }

    private void recache(ObjectSpecification newSpec) {
        this.cache.recache(newSpec);
    }

    @Programmatic
    public void validateAndAssert() {
        ValidationFailures validationFailures = this.validate();
        validationFailures.assertNone();
        this.cacheBySpecId();
    }

    @Programmatic
    public ValidationFailures validate() {
        if (this.validationFailures == null) {
            this.validationFailures = new ValidationFailures();
            this.metaModelValidator.validate(this.validationFailures);
        }
        return this.validationFailures;
    }

    @Programmatic
    public ObjectSpecification loadSpecification(String className) {
        assert (className != null);
        try {
            Class<?> cls = this.loadBuiltIn(className);
            return this.internalLoadSpecification(cls);
        }
        catch (ClassNotFoundException e) {
            ObjectSpecification spec = this.cache.get(className);
            if (spec == null) {
                throw new IsisException("No such class available: " + className);
            }
            return spec;
        }
    }

    @Programmatic
    public ObjectSpecification loadSpecification(Class<?> type) {
        ObjectSpecId specId;
        ObjectSpecification spec = this.internalLoadSpecification(type);
        if (spec == null) {
            return null;
        }
        if (this.cache.isInitialized() && spec.containsDoOpFacet(ObjectSpecIdFacet.class) && this.cache.getByObjectType(specId = spec.getSpecId()) == null) {
            this.cache.recache(spec);
        }
        return spec;
    }

    private ObjectSpecification internalLoadSpecification(Class<?> type) {
        DomainService domainServiceIfAny = type.getAnnotation(DomainService.class);
        NatureOfService natureOfServiceIfAny = domainServiceIfAny != null ? domainServiceIfAny.nature() : null;
        return this.internalLoadSpecification(type, natureOfServiceIfAny);
    }

    private ObjectSpecification internalLoadSpecification(Class<?> type, NatureOfService nature) {
        Class<?> substitutedType = this.classSubstitutor.getClass(type);
        return substitutedType != null ? this.loadSpecificationForSubstitutedClass(substitutedType, nature) : null;
    }

    private ObjectSpecification loadSpecificationForSubstitutedClass(Class<?> type, NatureOfService nature) {
        Assert.assertNotNull(type);
        String typeName = type.getName();
        ObjectSpecification spec = this.cache.get(typeName);
        if (spec != null) {
            return spec;
        }
        return this.loadSpecificationForSubstitutedClassSynchronized(type, nature);
    }

    private synchronized ObjectSpecification loadSpecificationForSubstitutedClassSynchronized(Class<?> type, NatureOfService natureOfService) {
        String typeName = type.getName();
        ObjectSpecification spec = this.cache.get(typeName);
        if (spec != null) {
            return spec;
        }
        ObjectSpecification specification = this.createSpecification(type, natureOfService);
        if (specification == null) {
            throw new IsisException("Failed to create specification for class " + typeName);
        }
        this.cache.cache(typeName, specification);
        this.introspectIfRequired(specification);
        return specification;
    }

    @Programmatic
    public boolean loadSpecifications(List<Class<?>> typesToLoad, Class<?> typeToIgnore) {
        boolean anyLoadedAsNull = false;
        for (Class<?> typeToLoad : typesToLoad) {
            if (typeToLoad == typeToIgnore) continue;
            ObjectSpecification noSpec = this.internalLoadSpecification(typeToLoad);
            boolean loadedAsNull = noSpec == null;
            anyLoadedAsNull = loadedAsNull || anyLoadedAsNull;
        }
        return anyLoadedAsNull;
    }

    @Programmatic
    public boolean loadSpecifications(List<Class<?>> typesToLoad) {
        return this.loadSpecifications(typesToLoad, null);
    }

    private ObjectSpecification createSpecification(Class<?> cls, NatureOfService natureOfServiceIfAny) {
        if (FreeStandingList.class.isAssignableFrom(cls)) {
            return new ObjectSpecificationOnStandaloneList(this.servicesInjector, this.facetProcessor);
        }
        FacetedMethodsBuilderContext facetedMethodsBuilderContext = new FacetedMethodsBuilderContext(this, this.facetProcessor, this.layoutMetadataReaders);
        return new ObjectSpecificationDefault(cls, facetedMethodsBuilderContext, this.servicesInjector, this.facetProcessor, natureOfServiceIfAny);
    }

    private Class<?> loadBuiltIn(String className) throws ClassNotFoundException {
        Class<?> builtIn = ClassUtil.getBuiltIn(className);
        if (builtIn != null) {
            return builtIn;
        }
        return Class.forName(className);
    }

    private ObjectSpecification introspectIfRequired(ObjectSpecification spec) {
        ObjectSpecificationAbstract specSpi = (ObjectSpecificationAbstract)spec;
        ObjectSpecificationAbstract.IntrospectionState introspectionState = specSpi.getIntrospectionState();
        if (introspectionState == ObjectSpecificationAbstract.IntrospectionState.NOT_INTROSPECTED) {
            specSpi.setIntrospectionState(ObjectSpecificationAbstract.IntrospectionState.BEING_INTROSPECTED);
            this.introspect(specSpi);
        } else if (introspectionState == ObjectSpecificationAbstract.IntrospectionState.BEING_INTROSPECTED) {
            this.introspect(specSpi);
        } else if (introspectionState == ObjectSpecificationAbstract.IntrospectionState.INTROSPECTED) {
            // empty if block
        }
        return spec;
    }

    private void introspect(ObjectSpecificationAbstract specSpi) {
        specSpi.introspectTypeHierarchyAndMembers();
        specSpi.updateFromFacetValues();
        specSpi.setIntrospectionState(ObjectSpecificationAbstract.IntrospectionState.INTROSPECTED);
    }

    @Programmatic
    public Collection<ObjectSpecification> allSpecifications() {
        return this.cache.allSpecifications();
    }

    @Programmatic
    public List<Class<?>> allServiceClasses() {
        List serviceClasses = Lists.transform(this.servicesInjector.getRegisteredServices(), (Function)new Function<Object, Class<?>>(){

            public Class<?> apply(Object o) {
                return o.getClass();
            }
        });
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)serviceClasses));
    }

    @Programmatic
    public boolean isServiceClass(Class<?> cls) {
        return this.servicesInjector.isRegisteredService(cls);
    }

    @Programmatic
    public boolean loaded(Class<?> cls) {
        return this.loaded(cls.getName());
    }

    @Programmatic
    public boolean loaded(String fullyQualifiedClassName) {
        return this.cache.get(fullyQualifiedClassName) != null;
    }

    @Programmatic
    public ObjectSpecification lookupBySpecId(ObjectSpecId objectSpecId) {
        ObjectSpecification objectSpecification = this.cache.getByObjectType(objectSpecId);
        if (objectSpecification == null) {
            return this.loadSpecification(objectSpecId.asString());
        }
        return objectSpecification;
    }
}

