/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetForContributee;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacetAbstract;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.specimpl.MixedInMember2;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationDefault;

public class OneToOneAssociationMixedIn
extends OneToOneAssociationDefault
implements MixedInMember2 {
    private final Class<?> mixinType;
    private final ObjectActionDefault mixinAction;
    private final ObjectSpecification mixedInType;
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private final Identifier identifier;

    public OneToOneAssociationMixedIn(ObjectActionDefault mixinAction, ObjectSpecification mixedInType, Class<?> mixinType, String mixinMethodName, ServicesInjector servicesInjector) {
        super(mixinAction.getFacetedMethod(), mixinAction.getReturnType(), servicesInjector);
        this.mixinType = mixinType;
        this.mixinAction = mixinAction;
        this.mixedInType = mixedInType;
        NotPersistedFacetAbstract notPersistedFacet = new NotPersistedFacetAbstract((FacetHolder)this){};
        DisabledFacet disabledFacet = this.disabledFacet();
        FacetUtil.addFacet(notPersistedFacet);
        FacetUtil.addFacet(disabledFacet);
        FacetUtil.copyFacets(mixinAction.getFacetedMethod(), this.facetHolder);
        String name = this.getName();
        if (Strings.isNullOrEmpty((String)name) || name.equalsIgnoreCase(mixinMethodName)) {
            String memberName = ObjectActionMixedIn.determineNameFrom(mixinAction);
            FacetUtil.addFacet(new NamedFacetInferred(memberName, this.facetHolder));
        }
        Identifier mixinIdentifier = mixinAction.getFacetedMethod().getIdentifier();
        List memberParameterNames = mixinIdentifier.getMemberParameterNames();
        this.identifier = Identifier.actionIdentifier((String)mixedInType.getCorrespondingClass().getName(), (String)this.getId(), (List)memberParameterNames);
    }

    private DisabledFacet disabledFacet() {
        DisabledFacet originalFacet = this.facetHolder.getFacet(DisabledFacet.class);
        if (originalFacet != null && originalFacet.when() == When.ALWAYS && originalFacet.where() == Where.ANYWHERE) {
            return originalFacet;
        }
        return new DisabledFacetForContributee("Contributed property", this);
    }

    @Override
    public ObjectAdapter get(final ObjectAdapter mixedInAdapter, final InteractionInitiatedBy interactionInitiatedBy) {
        final ObjectAdapter mixinAdapter = this.mixinAdapterFor(this.mixinType, mixedInAdapter);
        return this.getPublishingServiceInternal().withPublishingSuppressed(new PublishingServiceInternal.Block<ObjectAdapter>(){

            @Override
            public ObjectAdapter exec() {
                return OneToOneAssociationMixedIn.this.mixinAction.executeInternal(mixinAdapter, mixedInAdapter, new ObjectAdapter[0], interactionInitiatedBy);
            }
        });
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getId() {
        return OneToOneAssociationMixedIn.determineIdFrom(this.mixinAction);
    }

    @Override
    public String getOriginalId() {
        return super.getId();
    }

    @Override
    public Consent isVisible(ObjectAdapter mixedInAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        ObjectAdapter mixinAdapter = this.mixinAdapterFor(this.mixinType, mixedInAdapter);
        VisibilityContext<?> ic = this.mixinAction.createVisibleInteractionContext(mixinAdapter, interactionInitiatedBy, where);
        ic.setMixedIn(mixedInAdapter);
        return InteractionUtils.isVisibleResult(this, ic).createConsent();
    }

    @Override
    public Consent isUsable(ObjectAdapter mixedInAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        ObjectAdapter mixinAdapter = this.mixinAdapterFor(this.mixinType, mixedInAdapter);
        UsabilityContext<?> ic = this.mixinAction.createUsableInteractionContext(mixinAdapter, interactionInitiatedBy, where);
        ic.setMixedIn(mixedInAdapter);
        return InteractionUtils.isUsableResult(this, ic).createConsent();
    }

    @Override
    protected FacetHolder getFacetHolder() {
        return this.facetHolder;
    }

    @Override
    public ObjectSpecification getMixinType() {
        return this.getSpecificationLoader().loadSpecification(this.mixinType);
    }

    private PublishingServiceInternal getPublishingServiceInternal() {
        return this.getServicesInjector().lookupService(PublishingServiceInternal.class);
    }
}

