/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class MetaModelValidatorComposite
extends MetaModelValidatorAbstract {
    private final List<MetaModelValidator> validators = Lists.newArrayList();

    public MetaModelValidatorComposite add(MetaModelValidator validator) {
        this.validators.add(validator);
        return this;
    }

    public MetaModelValidatorComposite addAll(MetaModelValidator ... validators) {
        for (MetaModelValidator validator : validators) {
            this.add(validator);
        }
        return this;
    }

    @Override
    public void init(SpecificationLoader specificationLoader) {
        super.init(specificationLoader);
        for (MetaModelValidator validator : this.validators) {
            validator.init(specificationLoader);
        }
    }

    @Override
    public void validate(ValidationFailures validationFailures) {
        for (MetaModelValidator validator : this.validators) {
            validator.validate(validationFailures);
        }
    }

    public static MetaModelValidatorComposite asComposite(MetaModelValidator baseMetaModelValidator) {
        MetaModelValidatorComposite metaModelValidatorComposite = new MetaModelValidatorComposite();
        metaModelValidatorComposite.add(baseMetaModelValidator);
        return metaModelValidatorComposite;
    }
}

