/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAbstract;

public class MetaModelValidatorForDeprecatedAnnotation
extends MetaModelValidatorForDeprecatedAbstract {
    private String annotationName;

    public MetaModelValidatorForDeprecatedAnnotation(Class<?> annotationType) {
        this.annotationName = annotationType.getSimpleName();
    }

    @Override
    protected String failureMessageFor(Facet facet, FacetFactory.AbstractProcessWithMethodContext<?> processContext) {
        boolean inherited = MetaModelValidatorForDeprecatedAnnotation.isInherited(processContext);
        IdentifiedHolder facetHolder = (IdentifiedHolder)facet.getFacetHolder();
        Identifier identifier = facetHolder.getIdentifier();
        String id = identifier.toFullIdentityString();
        return String.format("%s%s: annotation '%s' is deprecated", id, inherited ? " (inherited)" : "", this.annotationName);
    }
}

