/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import java.util.Collection;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public final class MetaModelValidatorVisiting
extends MetaModelValidatorAbstract {
    private final Visitor visitor;

    public MetaModelValidatorVisiting(Visitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public final void validate(ValidationFailures validationFailures) {
        Collection<ObjectSpecification> objectSpecs = this.specificationLoader.allSpecifications();
        for (ObjectSpecification objSpec : objectSpecs) {
            if (!this.visitor.visit(objSpec, validationFailures)) break;
        }
        if (this.visitor instanceof SummarizingVisitor) {
            SummarizingVisitor summarizingVisitor = (SummarizingVisitor)this.visitor;
            summarizingVisitor.summarize(validationFailures);
        }
    }

    public static interface SummarizingVisitor
    extends Visitor {
        public void summarize(ValidationFailures var1);
    }

    public static interface Visitor {
        public boolean visit(ObjectSpecification var1, ValidationFailures var2);
    }
}

