/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DeweyOrderComparator
implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        Parsed p1 = new Parsed(o1);
        Parsed p2 = new Parsed(o2);
        return p1.compareTo(p2);
    }

    private static class Parsed<V>
    implements Comparable<Parsed<V>> {
        private static final Function<String, Integer> PARSE = new Function<String, Integer>(){

            public Integer apply(String input) {
                try {
                    return Integer.parseInt(input);
                }
                catch (NumberFormatException e) {
                    return Integer.MAX_VALUE;
                }
            }
        };
        private final List<Integer> parts;
        private final String key;

        Parsed(String key) {
            this.key = key;
            Iterable iter = Splitter.on((String)".").split((CharSequence)key);
            this.parts = Lists.newArrayList((Iterator)Iterators.transform(iter.iterator(), PARSE));
        }

        @Override
        public int compareTo(Parsed<V> other) {
            for (int i = 0; i < this.parts.size(); ++i) {
                Integer p = this.parts.get(i);
                if (other.parts.size() == i) {
                    return 1;
                }
                Integer q = other.parts.get(i);
                int comparison = p.compareTo(q);
                if (comparison == 0) continue;
                return comparison;
            }
            if (other.parts.size() > this.parts.size()) {
                return -1;
            }
            return 0;
        }
    }
}

