/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.threadpool;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolSupport.class);
    public static ThreadGroup group = new ThreadGroup(ThreadPoolSupport.class.getName());
    public static ThreadPoolExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> join(List<Future<Object>> futures) {
        if (futures == null) {
            return null;
        }
        long t0 = System.currentTimeMillis();
        try {
            ArrayList returnValues = Lists.newArrayList();
            for (Future<Object> future : futures) {
                returnValues.add(ThreadPoolSupport.join(future));
            }
            ArrayList arrayList = returnValues;
            return arrayList;
        }
        finally {
            long t1 = System.currentTimeMillis();
            LOG.info("join'ing {} tasks: waited {} milliseconds ", (Object)futures.size(), (Object)(t1 - t0));
        }
    }

    public static Object join(Future<Object> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    public static List<Future<Object>> invokeAll(List<Callable<Object>> callables) {
        try {
            return executor.invokeAll(callables);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int corePoolSize = Runtime.getRuntime().availableProcessors();
        int maximumPoolSize = Runtime.getRuntime().availableProcessors();
        int keepAliveTimeSecs = 5;
        int queueCapacity = 25;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(25);
        executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 5L, TimeUnit.SECONDS, workQueue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(group, r);
            }
        });
    }
}

