/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.base64;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;

public class Base64Serializer {
    public static Object fromString(String s) {
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
    }

    public static String toString(Serializable serializable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            String string = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
            return string;
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
    }

    public static class Exception
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public Exception(java.lang.Exception e) {
            super(e);
        }
    }
}

