/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.MapUtil;

public final class ClassUtil {
    static final String JAVA_CLASS_PREFIX = "java.";
    private static Map<String, Class<?>> builtInClasses = new HashMap();
    static final Map<Class<?>, Object> defaultByPrimitiveClass;
    static Map<Class<?>, Class<?>> wrapperClasses;
    static Map<Class<?>, Object> defaultByPrimitiveType;
    public static Map<String, Class<?>> primitives;

    private static void put(Class<?> cls) {
        builtInClasses.put(cls.getName(), cls);
    }

    private ClassUtil() {
    }

    public static Class<?> getBuiltIn(String name) {
        return builtInClasses.get(name);
    }

    public static Class<?> implementingClassOrNull(String classCandidateName, Class<?> requiredClass, Class<?> constructorParamType) {
        if (classCandidateName == null) {
            return null;
        }
        Class<?> classCandidate = null;
        try {
            classCandidate = Class.forName(classCandidateName);
            return ClassExtensions.implementingClassOrNull(classCandidate, requiredClass, constructorParamType);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean directlyImplements(Class<?> cls, Class<?> interfaceType) {
        for (Class<?> directlyImplementedInterface : cls.getInterfaces()) {
            if (directlyImplementedInterface != interfaceType) continue;
            return true;
        }
        return false;
    }

    public static boolean directlyImplements(Class<?> extendee, String interfaceTypeName) {
        try {
            Class<?> interfaceType = Thread.currentThread().getContextClassLoader().loadClass(interfaceTypeName);
            return ClassUtil.directlyImplements(extendee, interfaceType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> forName(String fullName) {
        Class<?> primitiveCls = primitives.get(fullName);
        if (primitiveCls != null) {
            return primitiveCls;
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fullName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> forNameElseNull(String fullName) {
        if (fullName == null) {
            return null;
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fullName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        ClassUtil.put(Void.TYPE);
        ClassUtil.put(Boolean.TYPE);
        ClassUtil.put(Character.TYPE);
        ClassUtil.put(Byte.TYPE);
        ClassUtil.put(Short.TYPE);
        ClassUtil.put(Integer.TYPE);
        ClassUtil.put(Long.TYPE);
        ClassUtil.put(Float.TYPE);
        ClassUtil.put(Double.TYPE);
        defaultByPrimitiveClass = MapUtil.asMap(Boolean.TYPE, false, Byte.TYPE, (byte)0, Short.TYPE, (short)0, Integer.TYPE, 0, Long.TYPE, 0L, Float.TYPE, Float.valueOf(0.0f), Double.TYPE, 0.0, Character.TYPE, Character.valueOf('\u0000'));
        wrapperClasses = MapUtil.asMap(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Void.TYPE, Void.class);
        defaultByPrimitiveType = new HashMap();
        defaultByPrimitiveType.put(Byte.TYPE, (byte)0);
        defaultByPrimitiveType.put(Short.TYPE, (short)0);
        defaultByPrimitiveType.put(Integer.TYPE, 0);
        defaultByPrimitiveType.put(Long.TYPE, 0L);
        defaultByPrimitiveType.put(Character.TYPE, 0);
        defaultByPrimitiveType.put(Float.TYPE, Float.valueOf(0.0f));
        defaultByPrimitiveType.put(Double.TYPE, 0.0);
        defaultByPrimitiveType.put(Boolean.TYPE, false);
        primitives = Maps.newHashMap();
        List<Class> primitiveClasses = Arrays.asList(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE);
        for (Class cls : primitiveClasses) {
            primitives.put(cls.getName(), cls);
        }
    }
}

