/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public interface Oid
extends Encodable {
    public String enString(OidMarshaller var1);

    public String enStringNoVersion(OidMarshaller var1);

    public Version getVersion();

    public void setVersion(Version var1);

    public boolean isTransient();

    public boolean isViewModel();

    public boolean isPersistent();

    public static final class Matchers {
        private Matchers() {
        }

        public static Matcher<Oid> isTransient() {
            return new TypeSafeMatcher<Oid>(){

                public boolean matchesSafely(Oid item) {
                    return item.isTransient();
                }

                public void describeTo(Description description) {
                    description.appendText("is transient");
                }
            };
        }

        public static Matcher<Oid> isPersistent() {
            return new TypeSafeMatcher<Oid>(){

                public boolean matchesSafely(Oid item) {
                    return !item.isTransient();
                }

                public void describeTo(Description description) {
                    description.appendText("is persistent");
                }
            };
        }
    }

    public static enum State {
        PERSISTENT("P"),
        TRANSIENT("T"),
        VIEWMODEL("V");

        private final String code;

        private State(String code) {
            this.code = code;
        }

        public boolean isTransient() {
            return this == TRANSIENT;
        }

        public boolean isViewModel() {
            return this == VIEWMODEL;
        }

        public boolean isPersistent() {
            return this == PERSISTENT;
        }

        public String getCode() {
            return this.code;
        }
    }
}

