/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.MethodUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;

public final class AdapterInvokeUtils {
    private AdapterInvokeUtils() {
    }

    public static void invokeAll(List<Method> methods, ObjectAdapter adapter) {
        MethodUtil.invoke(methods, AdapterUtils.unwrap(adapter));
    }

    public static Object invoke(Method method, ObjectAdapter adapter) {
        return MethodExtensions.invoke(method, AdapterUtils.unwrap(adapter));
    }

    public static Object invoke(Method method, ObjectAdapter adapter, Object arg0) {
        return MethodExtensions.invoke(method, AdapterUtils.unwrap(adapter), new Object[]{arg0});
    }

    public static Object invoke(Method method, ObjectAdapter adapter, ObjectAdapter arg0Adapter) {
        return AdapterInvokeUtils.invoke(method, adapter, AdapterUtils.unwrap(arg0Adapter));
    }

    public static Object invoke(Method method, ObjectAdapter adapter, ObjectAdapter[] argumentAdapters) {
        return MethodExtensions.invoke(method, AdapterUtils.unwrap(adapter), AdapterUtils.unwrap(argumentAdapters));
    }

    public static Object invoke(Method method, ObjectAdapter adapter, Map<Integer, ObjectAdapter> argumentAdapters) {
        return AdapterInvokeUtils.invoke(method, adapter, AdapterInvokeUtils.asArray(argumentAdapters, method.getParameterTypes().length));
    }

    private static ObjectAdapter[] asArray(Map<Integer, ObjectAdapter> argumentAdapters, int length) {
        ObjectAdapter[] args = new ObjectAdapter[length];
        for (Map.Entry<Integer, ObjectAdapter> entry : argumentAdapters.entrySet()) {
            Integer paramNum = entry.getKey();
            if (paramNum >= length) continue;
            args[paramNum.intValue()] = entry.getValue();
        }
        return args;
    }

    public static Object invokeAutofit(Method method, ObjectAdapter target, List<ObjectAdapter> argumentsIfAvailable, AdapterManager adapterManager) {
        ArrayList args = Lists.newArrayList();
        if (argumentsIfAvailable != null) {
            args.addAll(argumentsIfAvailable);
        }
        AdapterInvokeUtils.adjust(method, args, adapterManager);
        ObjectAdapter[] argArray = args.toArray(new ObjectAdapter[0]);
        return AdapterInvokeUtils.invoke(method, target, argArray);
    }

    private static void adjust(Method method, List<ObjectAdapter> args, AdapterManager adapterManager) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        ListExtensions.adjust(args, parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> cls = parameterTypes[i];
            if (args.get(i) != null || !cls.isPrimitive()) continue;
            Object object = ClassExtensions.toDefault(cls);
            ObjectAdapter adapter = adapterManager.adapterFor(object);
            args.set(i, adapter);
        }
    }

    private static Object invokeWithDefaults(Method method, ObjectAdapter adapter, ObjectAdapter[] argumentAdapters) {
        ObjectAdapter[] adapters;
        int numParams = method.getParameterTypes().length;
        if (argumentAdapters == null || argumentAdapters.length == 0) {
            adapters = new ObjectAdapter[numParams];
        } else if (numParams == 0) {
            adapters = new ObjectAdapter[]{};
        } else if (argumentAdapters.length == numParams) {
            adapters = argumentAdapters;
        } else {
            throw new IllegalArgumentException("Method has " + numParams + " params but " + argumentAdapters.length + " arguments provided");
        }
        return AdapterInvokeUtils.invoke(method, adapter, adapters);
    }
}

