/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;

public class FacetHolderImpl
implements FacetHolder {
    private final Map<Class<? extends Facet>, Facet> facetsByClass = new HashMap<Class<? extends Facet>, Facet>();

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.getFacet(facetType) != null;
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        Facet facet = this.getFacet(facetType);
        return facet != null && !facet.isNoop();
    }

    @Override
    public void addFacet(Facet facet) {
        this.addFacet(facet.facetType(), facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        Class<? extends Facet>[] facetTypes;
        for (Class<? extends Facet> facetType : facetTypes = facet.facetTypes()) {
            this.addFacet(facetType, facet.getFacet(facetType));
        }
    }

    private void addFacet(Class<? extends Facet> facetType, Facet facet) {
        Facet existingFacet = this.getFacet(facetType);
        if (existingFacet == null || existingFacet.isNoop()) {
            this.facetsByClass.put(facetType, facet);
            return;
        }
        if (!facet.alwaysReplace()) {
            return;
        }
        if (facet.isDerived() && !existingFacet.isDerived()) {
            return;
        }
        facet.setUnderlyingFacet(existingFacet);
        this.facetsByClass.put(facetType, facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        FacetUtil.removeFacet(this.facetsByClass, facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        FacetUtil.removeFacet(this.facetsByClass, facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facetType) {
        return (T)this.facetsByClass.get(facetType);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return FacetUtil.getFacetTypes(this.facetsByClass);
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return FacetUtil.getFacets(this.facetsByClass, filter);
    }
}

