/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.lang.PropertiesExtensions;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public interface ContributeeMemberFacetFactory
extends FacetFactory {
    public void process(ProcessContributeeMemberContext var1);

    public static class ProcessContributeeMemberContext
    extends FacetFactory.AbstractProcessContext<ObjectMember>
    implements FacetFactory.ProcessContextWithMetadataProperties<ObjectMember> {
        private final Properties metadataProperties;

        public ProcessContributeeMemberContext(Properties metadataProperties, ObjectMember facetHolder) {
            super(facetHolder);
            this.metadataProperties = metadataProperties;
        }

        @Override
        public Properties metadataProperties(String subKey) {
            if (this.metadataProperties == null) {
                return null;
            }
            Identifier identifier = ((ObjectMember)this.getFacetHolder()).getIdentifier();
            String id = identifier.getMemberName();
            ArrayList keys = Lists.newArrayList();
            if (this.getFacetHolder() instanceof ObjectAction) {
                keys.add("action." + id + "." + subKey);
                keys.add("member." + id + "()" + "." + subKey);
            } else if (this.getFacetHolder() instanceof OneToOneAssociation) {
                keys.add("property." + id + "." + subKey);
                keys.add("member." + id + "." + subKey);
            } else if (this.getFacetHolder() instanceof OneToManyAssociation) {
                keys.add("member." + id + "." + subKey);
                keys.add("collection." + id + "." + subKey);
            }
            for (String key : keys) {
                Properties subsetProperties = PropertiesExtensions.subset(this.metadataProperties, key);
                if (subsetProperties.isEmpty()) continue;
                return subsetProperties;
            }
            return null;
        }
    }
}

