/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.modify;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public final class CollectionFacetUtils {
    private CollectionFacetUtils() {
    }

    public static CollectionFacet getCollectionFacetFromSpec(ObjectAdapter objectRepresentingCollection) {
        ObjectSpecification collectionSpec = objectRepresentingCollection.getSpecification();
        return collectionSpec.getFacet(CollectionFacet.class);
    }

    public static int size(ObjectAdapter collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        return facet.size(collection);
    }

    public static ObjectAdapter firstElement(ObjectAdapter collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        return facet.firstElement(collection);
    }

    @Deprecated
    public static Object[] convertToArray(ObjectAdapter collection) {
        return CollectionFacetUtils.convertToList(collection).toArray();
    }

    public static List<Object> convertToList(ObjectAdapter collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        ArrayList<Object> objects = new ArrayList<Object>();
        for (ObjectAdapter adapter : facet.iterable(collection)) {
            objects.add(adapter.getObject());
        }
        return objects;
    }

    public static List<ObjectAdapter> convertToAdapterList(ObjectAdapter collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        ArrayList<ObjectAdapter> adapters = new ArrayList<ObjectAdapter>();
        for (ObjectAdapter adapter : facet.iterable(collection)) {
            adapters.add(adapter);
        }
        return adapters;
    }
}

