/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.mandatory;

import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.MarkerFacetAbstract;
import org.apache.isis.core.metamodel.facets.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgumentContext;
import org.apache.isis.core.metamodel.interactions.PropertyModifyContext;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.ValidityContext;

public abstract class MandatoryFacetAbstract
extends MarkerFacetAbstract
implements MandatoryFacet {
    private Semantics semantics;

    public static Class<? extends Facet> type() {
        return MandatoryFacet.class;
    }

    public MandatoryFacetAbstract(FacetHolder holder, Semantics semantics) {
        super(MandatoryFacetAbstract.type(), holder);
        this.semantics = semantics;
    }

    @Override
    public final boolean isRequiredButNull(ObjectAdapter adapter) {
        if (!this.isInvertedSemantics()) {
            Object object = ObjectAdapter.Util.unwrap(adapter);
            if (object == null) {
                return true;
            }
            String str = ObjectAdapter.Util.unwrapAsString(adapter);
            return str != null && str.length() == 0;
        }
        return false;
    }

    @Override
    public boolean isInvertedSemantics() {
        return this.semantics == Semantics.OPTIONAL;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> context) {
        if (!(context instanceof PropertyModifyContext) && !(context instanceof ActionArgumentContext)) {
            return null;
        }
        if (!(context instanceof ProposedHolder)) {
            return null;
        }
        ProposedHolder proposedHolder = (ProposedHolder)((Object)context);
        boolean required = this.isRequiredButNull(proposedHolder.getProposed());
        if (required) {
            NamedFacet namedFacet = this.getFacetHolder().getFacet(NamedFacet.class);
            String name = namedFacet != null ? namedFacet.value() : null;
            return name != null ? name + " is mandatory" : "Mandatory";
        }
        return null;
    }

    public static enum Semantics {
        REQUIRED,
        OPTIONAL;


        public static Semantics of(boolean required) {
            return required ? REQUIRED : OPTIONAL;
        }
    }
}

