/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.audit.configuration;

import org.apache.isis.applib.services.HasTransactionId;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.audit.configuration.AuditableFacetFromConfiguration;

public class AuditableFromConfigurationFacetFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware {
    private static final String AUDIT_OBJECTS_KEY = "isis.services.audit.objects";
    private IsisConfiguration configuration;

    public AuditableFromConfigurationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        String configuredValue = this.configuration.getString(AUDIT_OBJECTS_KEY);
        ObjectCategorization categorization = ObjectCategorization.parse(configuredValue);
        if (categorization == ObjectCategorization.NONE) {
            return;
        }
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        if (facetHolder.containsDoOpFacet(AuditableFacet.class)) {
            return;
        }
        if (HasTransactionId.class.isAssignableFrom(cls)) {
            return;
        }
        FacetUtil.addFacet(new AuditableFacetFromConfiguration((FacetHolder)facetHolder));
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    private static enum ObjectCategorization {
        ALL,
        NONE;


        public static ObjectCategorization parse(String value) {
            if ("all".equalsIgnoreCase(value)) {
                return ALL;
            }
            return NONE;
        }
    }
}

