/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInjectorDefault
implements ServicesInjectorSpi {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInjectorDefault.class);
    private final Map<Class<?>, List<Object>> servicesByType = Maps.newHashMap();
    private DomainObjectContainer container;
    private final List<Object> services = Lists.newArrayList();

    @Override
    public void init() {
        this.autowireServicesAndContainer();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public DomainObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(DomainObjectContainer container) {
        Ensure.ensureThatArg(container, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.container = container;
        this.autowireServicesAndContainer();
    }

    @Override
    public void setServices(List<Object> services) {
        this.services.clear();
        this.addServices(services);
        this.autowireServicesAndContainer();
    }

    @Override
    public List<Object> getRegisteredServices() {
        return Collections.unmodifiableList(this.services);
    }

    private void addServices(List<Object> services) {
        for (Object service : services) {
            if (service instanceof List) {
                List<Object> serviceList = ObjectExtensions.asListT(service, Object.class);
                this.addServices(serviceList);
                continue;
            }
            this.addService(service);
        }
    }

    private boolean addService(Object service) {
        return this.services.add(service);
    }

    @Override
    public void injectServicesInto(Object object) {
        Assert.assertNotNull("no container", this.container);
        Assert.assertNotNull("no services", this.services);
        ArrayList servicesCopy = Lists.newArrayList(this.services);
        servicesCopy.add(this.container);
        ServicesInjectorDefault.injectServices(object, servicesCopy);
    }

    @Override
    public void injectServicesInto(List<Object> objects) {
        for (Object object : objects) {
            this.injectServicesInto(object);
        }
    }

    @Override
    public void injectInto(Object candidate) {
        if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
            cast.setServicesInjector(this);
        }
    }

    private static void injectServices(Object object, List<Object> services) {
        Class<?> cls = object.getClass();
        ServicesInjectorDefault.autowireViaFields(object, services, cls);
        ServicesInjectorDefault.autowireViaPrefixedMethods(object, services, cls, "set");
        ServicesInjectorDefault.autowireViaPrefixedMethods(object, services, cls, "inject");
    }

    private static void autowireViaFields(Object object, List<Object> services, Class<?> cls) {
        List<Field> fields = Arrays.asList(cls.getDeclaredFields());
        Iterable injectFields = Iterables.filter(fields, (Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                Inject annotation = input.getAnnotation(Inject.class);
                return annotation != null;
            }
        });
        for (Field field : injectFields) {
            for (Object service : services) {
                Class<?> serviceClass = service.getClass();
                boolean isInjectorField = ServicesInjectorDefault.isInjectorFieldFor(field, serviceClass);
                if (!isInjectorField) continue;
                field.setAccessible(true);
                ServicesInjectorDefault.invokeInjectorField(field, object, service);
            }
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            ServicesInjectorDefault.autowireViaFields(object, services, superclass);
        }
    }

    private static void autowireViaPrefixedMethods(Object object, List<Object> services, Class<?> cls, final String prefix) {
        List<Method> methods = Arrays.asList(cls.getMethods());
        Iterable prefixedMethods = Iterables.filter(methods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                String methodName = method.getName();
                return methodName.startsWith(prefix);
            }
        });
        for (Method prefixedMethod : prefixedMethods) {
            for (Object service : services) {
                Class<?> serviceClass = service.getClass();
                boolean isInjectorMethod = ServicesInjectorDefault.isInjectorMethodFor(prefixedMethod, serviceClass);
                if (!isInjectorMethod) continue;
                prefixedMethod.setAccessible(true);
                ServicesInjectorDefault.invokeInjectorMethod(prefixedMethod, object, service);
            }
        }
    }

    private static boolean isInjectorFieldFor(Field field, Class<?> serviceClass) {
        Class<?> type = field.getType();
        return type != null && type.isAssignableFrom(serviceClass);
    }

    public static boolean isInjectorMethodFor(Method method, Class<?> serviceClass) {
        Class<?>[] parameterTypes;
        String methodName = method.getName();
        return (methodName.startsWith("set") || methodName.startsWith("inject")) && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0] != Object.class && parameterTypes[0].isAssignableFrom(serviceClass);
    }

    private static void invokeMethod(Method method, Object target, Object[] parameters) {
        try {
            method.invoke(target, parameters);
        }
        catch (SecurityException e) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (IllegalArgumentException e1) {
            throw new MetaModelException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new MetaModelException(targetException);
        }
    }

    private static void invokeInjectorField(Field field, Object target, Object parameter) {
        try {
            field.set(target, parameter);
        }
        catch (IllegalArgumentException e) {
            throw new MetaModelException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaModelException(String.format("Cannot access the %s field in %s", field.getName(), target.getClass().getName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected " + parameter + " into " + new ToString(target));
        }
    }

    private static void invokeInjectorMethod(Method method, Object target, Object parameter) {
        Object[] parameters = new Object[]{parameter};
        ServicesInjectorDefault.invokeMethod(method, target, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected " + parameter + " into " + new ToString(target));
        }
    }

    private void autowireServicesAndContainer() {
        this.injectServicesInto(this.services);
        this.injectServicesInto(this.container);
    }

    @Override
    public <T> T lookupService(Class<T> serviceClass) {
        List<T> services = this.lookupServices(serviceClass);
        return !services.isEmpty() ? (T)services.get(0) : null;
    }

    @Override
    public <T> List<T> lookupServices(Class<T> serviceClass) {
        this.locateAndCache(serviceClass);
        return this.servicesByType.get(serviceClass);
    }

    private void locateAndCache(Class<?> serviceClass) {
        if (this.servicesByType.containsKey(serviceClass)) {
            return;
        }
        ArrayList matchingServices = Lists.newArrayList();
        ServicesInjectorDefault.addAssignableTo(serviceClass, this.services, matchingServices);
        ServicesInjectorDefault.addAssignableTo(serviceClass, ServicesInjectorDefault.singletonListFor(this.container), matchingServices);
        this.servicesByType.put(serviceClass, matchingServices);
    }

    private static List<Object> singletonListFor(Object obj) {
        return obj != null ? Collections.singletonList(obj) : Collections.emptyList();
    }

    private static void addAssignableTo(Class<?> type, List<Object> candidates, List<Object> filteredServicesAndContainer) {
        Iterable filteredServices = Iterables.filter(candidates, ServicesInjectorDefault.ofType(type));
        filteredServicesAndContainer.addAll(Lists.newArrayList((Iterable)filteredServices));
    }

    private static final Predicate<Object> ofType(final Class<?> cls) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return cls.isAssignableFrom(input.getClass());
            }
        };
    }
}

