/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.bookmarks;

import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.NotContributed;
import org.apache.isis.applib.annotation.NotInServiceMenu;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkHolder;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.core.metamodel.adapter.DomainObjectServices;
import org.apache.isis.core.metamodel.adapter.DomainObjectServicesAware;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;

public class BookmarkServiceDefault
implements BookmarkService,
DomainObjectServicesAware {
    private DomainObjectServices domainObjectServices;

    @NotInServiceMenu
    @NotContributed(value=NotContributed.As.ASSOCIATION)
    public Object lookup(BookmarkHolder bookmarkHolder) {
        Bookmark bookmark = bookmarkHolder.bookmark();
        return bookmark != null ? this.lookup(bookmark) : null;
    }

    @NotInServiceMenu
    @NotContributed(value=NotContributed.As.ACTION)
    public Object object(BookmarkHolder bookmarkHolder) {
        return this.lookup(bookmarkHolder);
    }

    @Hidden
    public Object lookup(Bookmark bookmark) {
        if (bookmark == null) {
            return null;
        }
        try {
            return this.domainObjectServices.lookup(bookmark);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    @Hidden
    public <T> T lookup(Bookmark bookmark, Class<T> cls) {
        return (T)this.lookup(bookmark);
    }

    @Hidden
    public Bookmark bookmarkFor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        return this.domainObjectServices.bookmarkFor(domainObject);
    }

    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        return this.domainObjectServices.bookmarkFor(cls, identifier);
    }

    @Override
    @Programmatic
    public void setDomainObjectServices(DomainObjectServices domainObjectServices) {
        this.domainObjectServices = domainObjectServices;
    }
}

