/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.devutils;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.devutils.DeveloperUtilitiesService;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.layoutmetadata.json.LayoutMetadataReaderFromJson;
import org.apache.isis.core.metamodel.services.devutils.MetaModelRow;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpiAware;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public class DeveloperUtilitiesServiceDefault
implements DeveloperUtilitiesService,
SpecificationLoaderSpiAware,
AdapterManagerAware {
    private final MimeType mimeTypeTextCsv;
    private final MimeType mimeTypeApplicationZip;
    private final MimeType mimeTypeApplicationJson;
    private SpecificationLoaderSpi specificationLoader;
    private AdapterManager adapterManager;

    public DeveloperUtilitiesServiceDefault() {
        try {
            this.mimeTypeTextCsv = new MimeType("text", "csv");
            this.mimeTypeApplicationJson = new MimeType("application", "jzon");
            this.mimeTypeApplicationZip = new MimeType("application", "zip");
        }
        catch (MimeTypeParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Clob downloadMetaModel() {
        Collection<ObjectSpecification> specifications = this.specificationLoader.allSpecifications();
        ArrayList rows = Lists.newArrayList();
        for (ObjectSpecification spec : specifications) {
            if (this.exclude(spec)) continue;
            List<ObjectAssociation> properties = spec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES);
            for (ObjectAssociation property : properties) {
                OneToOneAssociation otoa = (OneToOneAssociation)property;
                if (this.exclude(otoa)) continue;
                rows.add(new MetaModelRow(spec, otoa));
            }
            List<ObjectAssociation> associations = spec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.COLLECTIONS);
            for (ObjectAssociation collection : associations) {
                OneToManyAssociation otma = (OneToManyAssociation)collection;
                if (this.exclude(otma)) continue;
                rows.add(new MetaModelRow(spec, otma));
            }
            List<ObjectAction> actions = spec.getObjectActions(Contributed.INCLUDED);
            for (ObjectAction action : actions) {
                if (this.exclude(action)) continue;
                rows.add(new MetaModelRow(spec, action));
            }
        }
        Collections.sort(rows);
        StringBuilder buf = new StringBuilder();
        buf.append(MetaModelRow.header()).append("\n");
        for (MetaModelRow row : rows) {
            buf.append(row.asTextCsv()).append("\n");
        }
        return new Clob("metamodel.csv", this.mimeTypeTextCsv, buf.toString().toCharArray());
    }

    protected boolean exclude(OneToOneAssociation property) {
        return false;
    }

    protected boolean exclude(OneToManyAssociation collection) {
        return false;
    }

    protected boolean exclude(ObjectAction action) {
        return false;
    }

    protected boolean exclude(ObjectSpecification spec) {
        return this.isBuiltIn(spec) || spec.isAbstract();
    }

    protected boolean isBuiltIn(ObjectSpecification spec) {
        String className = spec.getFullIdentifier();
        return className.startsWith("java") || className.startsWith("org.joda") || className.startsWith("org.apache.isis");
    }

    public void refreshServices() {
        ArrayList specifications = Lists.newArrayList(this.specificationLoader.allSpecifications());
        for (ObjectSpecification objectSpec : specifications) {
            if (!objectSpec.isService()) continue;
            this.specificationLoader.invalidateCache(objectSpec.getCorrespondingClass());
        }
    }

    public Object refreshLayout(Object domainObject) {
        this.specificationLoader.invalidateCacheFor(domainObject);
        return domainObject;
    }

    public Clob downloadLayout(Object domainObject) {
        ObjectAdapter adapterFor = this.adapterManager.adapterFor(domainObject);
        ObjectSpecification objectSpec = adapterFor.getSpecification();
        LayoutMetadataReaderFromJson propertiesReader = new LayoutMetadataReaderFromJson();
        String json = propertiesReader.asJson(objectSpec);
        return new Clob(objectSpec.getShortIdentifier() + ".layout.json", this.mimeTypeApplicationJson, (CharSequence)json);
    }

    public Blob downloadLayouts() {
        LayoutMetadataReaderFromJson propertiesReader = new LayoutMetadataReaderFromJson();
        Collection<ObjectSpecification> allSpecs = this.specificationLoader.allSpecifications();
        Collection domainObjectSpecs = Collections2.filter(allSpecs, (Predicate)new Predicate<ObjectSpecification>(){

            public boolean apply(ObjectSpecification input) {
                return !input.isAbstract() && !input.isService() && !input.isValue() && !input.isParentedOrFreeCollection();
            }
        });
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            OutputStreamWriter writer = new OutputStreamWriter(zos);
            for (ObjectSpecification objectSpec : domainObjectSpecs) {
                zos.putNextEntry(new ZipEntry(DeveloperUtilitiesServiceDefault.zipEntryNameFor(objectSpec)));
                writer.write(propertiesReader.asJson(objectSpec));
                writer.flush();
                zos.closeEntry();
            }
            writer.close();
            return new Blob("layouts.zip", this.mimeTypeApplicationZip, baos.toByteArray());
        }
        catch (IOException ex) {
            throw new FatalException("Unable to create zip of layouts", (Throwable)ex);
        }
    }

    private static String zipEntryNameFor(ObjectSpecification objectSpec) {
        String fqn = objectSpec.getFullIdentifier();
        return fqn.replace(".", File.separator) + ".layout.json";
    }

    @Override
    @Programmatic
    public void setSpecificationLoaderSpi(SpecificationLoaderSpi specificationLoader) {
        this.specificationLoader = specificationLoader;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }
}

