/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.CurrentHolder;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;

public interface ObjectAssociation
extends ObjectMember,
CurrentHolder {
    public String getBusinessKeyName();

    public ObjectAdapter getDefault(ObjectAdapter var1);

    public void toDefault(ObjectAdapter var1);

    public boolean hasChoices();

    public ObjectAdapter[] getChoices(ObjectAdapter var1);

    public boolean hasAutoComplete();

    public ObjectAdapter[] getAutoComplete(ObjectAdapter var1, String var2);

    public int getAutoCompleteMinLength();

    public boolean isNotPersisted();

    public boolean isEmpty(ObjectAdapter var1);

    public boolean isMandatory();

    public static class Util {
        private Util() {
        }

        public static Map<String, List<ObjectAssociation>> groupByMemberOrderName(List<ObjectAssociation> associations) {
            HashMap associationsByGroup = Maps.newHashMap();
            for (ObjectAssociation association : associations) {
                Util.addAssociationIntoGroup(associationsByGroup, association);
            }
            return associationsByGroup;
        }

        private static void addAssociationIntoGroup(Map<String, List<ObjectAssociation>> associationsByGroup, ObjectAssociation association) {
            String name;
            MemberOrderFacet memberOrderFacet = association.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet != null && !Strings.isNullOrEmpty((String)(name = memberOrderFacet.name()))) {
                Util.getFrom(associationsByGroup, name).add(association);
                return;
            }
            Util.getFrom(associationsByGroup, "General").add(association);
        }

        private static List<ObjectAssociation> getFrom(Map<String, List<ObjectAssociation>> associationsByGroup, String groupName) {
            ArrayList list = associationsByGroup.get(groupName);
            if (list == null) {
                list = Lists.newArrayList();
                associationsByGroup.put(groupName, list);
            }
            return list;
        }
    }

    public static class Filters {
        public static final Filter<ObjectAssociation> PROPERTIES = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                return association.isOneToOneAssociation();
            }
        };
        public static final Filter<ObjectAssociation> REFERENCE_PROPERTIES = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                return association.isOneToOneAssociation() && !association.getSpecification().containsDoOpFacet(ValueFacet.class);
            }
        };
        public static final Filter<ObjectAssociation> WHERE_VISIBLE_IN_COLLECTION_TABLE = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                HiddenFacet hiddenFacet = association.getFacet(HiddenFacet.class);
                return hiddenFacet == null || !hiddenFacet.where().inParentedTable();
            }
        };
        public static final Filter<ObjectAssociation> WHERE_VISIBLE_IN_STANDALONE_TABLE = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                HiddenFacet hiddenFacet = association.getFacet(HiddenFacet.class);
                return hiddenFacet == null || !hiddenFacet.where().inStandaloneTable();
            }
        };
        public static final Filter<ObjectAssociation> ALL = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation property) {
                return true;
            }
        };
        public static final Filter<ObjectAssociation> COLLECTIONS = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation property) {
                return property.isOneToManyAssociation();
            }
        };
        public static final Filter<ObjectAssociation> VISIBLE_AT_LEAST_SOMETIMES = new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation property) {
                HiddenFacet hiddenFacet = property.getFacet(HiddenFacet.class);
                return hiddenFacet == null || hiddenFacet.when() != When.ALWAYS || hiddenFacet.where() != Where.ANYWHERE;
            }
        };

        private Filters() {
        }

        public static final Filter<ObjectAssociation> staticallyVisible(final Where context) {
            return new Filter<ObjectAssociation>(){

                public boolean accept(ObjectAssociation association) {
                    HiddenFacet facet = association.getFacet(HiddenFacet.class);
                    if (facet == null) {
                        return true;
                    }
                    return !facet.where().includes(context) || facet.when() != When.ALWAYS;
                }
            };
        }

        public static Filter<ObjectAssociation> dynamicallyVisible(final AuthenticationSession session, final ObjectAdapter target, final Where where) {
            return new Filter<ObjectAssociation>(){

                public boolean accept(ObjectAssociation objectAssociation) {
                    Consent visible = objectAssociation.isVisible(session, target, where);
                    return visible.isAllowed();
                }
            };
        }

        public static Filter<ObjectAssociation> enabled(final AuthenticationSession session, final ObjectAdapter adapter, final Where where) {
            return new Filter<ObjectAssociation>(){

                public boolean accept(ObjectAssociation objectAssociation) {
                    Consent usable = objectAssociation.isUsable(session, adapter, where);
                    return usable.isAllowed();
                }
            };
        }
    }

    public static class Predicates {
        private Predicates() {
        }

        public static Predicate<ObjectAssociation> being(final Contributed contributed) {
            return new Predicate<ObjectAssociation>(){

                public boolean apply(ObjectAssociation t) {
                    return contributed.isIncluded() || !(t instanceof ContributeeMember);
                }
            };
        }
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectAssociation, String> toName() {
            return new Function<ObjectAssociation, String>(){

                public String apply(ObjectAssociation oa) {
                    return oa.getName();
                }
            };
        }

        public static Function<ObjectAssociation, String> toId() {
            return new Function<ObjectAssociation, String>(){

                public String apply(ObjectAssociation oa) {
                    return oa.getId();
                }
            };
        }
    }
}

