/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInitializer.class);
    private Map<String, String> props;
    private Map<Object, Method> postConstructMethodsByService = Maps.newLinkedHashMap();
    private Map<Object, Method> preDestroyMethodsByService = Maps.newLinkedHashMap();

    public void validate(IsisConfiguration configuration, DomainObjectContainer container, List<Object> services) {
        this.props = configuration.asMap();
        for (Object service : services) {
            Class<?>[] parameterTypes;
            Method existing;
            Method[] methods;
            LOG.debug("checking for @PostConstruct and @PostDestroy methods on " + service.getClass().getName());
            for (Method method : methods = service.getClass().getMethods()) {
                PostConstruct postConstructAnnotation = method.getAnnotation(PostConstruct.class);
                if (postConstructAnnotation == null) continue;
                existing = this.postConstructMethodsByService.get(service);
                if (existing != null) {
                    throw new RuntimeException("Found more than one @PostConstruct method; service is: " + service.getClass().getName() + ", found " + existing.getName() + " and " + method.getName());
                }
                parameterTypes = method.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (Map.class == parameterTypes[0]) break;
                        throw new RuntimeException("@PostConstruct method must be no-arg or 1-arg accepting java.util.Map; method is: " + service.getClass().getName() + "#" + method.getName());
                    }
                    default: {
                        throw new RuntimeException("@PostConstruct method must be no-arg or 1-arg accepting java.util.Map; method is: " + service.getClass().getName() + "#" + method.getName());
                    }
                }
                this.postConstructMethodsByService.put(service, method);
            }
            for (Method method : methods) {
                PreDestroy preDestroyAnnotation = method.getAnnotation(PreDestroy.class);
                if (preDestroyAnnotation == null) continue;
                existing = this.preDestroyMethodsByService.get(service);
                if (existing != null) {
                    throw new RuntimeException("Found more than one @PreDestroy method; service is: " + service.getClass().getName() + ", found " + existing.getName() + " and " + method.getName());
                }
                parameterTypes = method.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("@PreDestroy method must be no-arg; method is: " + service.getClass().getName() + "#" + method.getName());
                    }
                }
                this.preDestroyMethodsByService.put(service, method);
            }
        }
    }

    public void postConstruct() {
        LOG.info("calling @PostConstruct on all domain services");
        for (Map.Entry<Object, Method> entry : this.postConstructMethodsByService.entrySet()) {
            Object service = entry.getKey();
            Method method = entry.getValue();
            LOG.info("... calling @PostConstruct method: " + service.getClass().getName() + ": " + method.getName());
            int numParams = method.getParameterTypes().length;
            if (numParams == 0) {
                MethodExtensions.invoke(method, service);
                continue;
            }
            MethodExtensions.invoke(method, service, new Object[]{this.props});
        }
    }

    public void preDestroy() {
        LOG.info("calling @PreDestroy on all domain services");
        for (Map.Entry<Object, Method> entry : this.preDestroyMethodsByService.entrySet()) {
            Object service = entry.getKey();
            Method method = entry.getValue();
            LOG.info("... calling @PreDestroy method: " + service.getClass().getName() + ": " + method.getName());
            try {
                MethodExtensions.invoke(method, service);
            }
            catch (Exception ex) {
                LOG.warn("... @PreDestroy method threw exception - continuing anyway", (Throwable)ex);
            }
        }
    }

    static class ServiceInitMethods {
        Object service;
        Method postConstruct;
        Method preDestrory;

        ServiceInitMethods() {
        }
    }
}

