/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.classsubstitutor;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutorAware;

public class ClassSubstitutorComposite
implements ClassSubstitutor {
    private final List<ClassSubstitutor> substitutors = Lists.newArrayList();

    public ClassSubstitutorComposite(List<ClassSubstitutor> substitutors) {
        this.substitutors.addAll(substitutors);
    }

    public ClassSubstitutorComposite(ClassSubstitutor ... substitutors) {
        this(Arrays.asList(substitutors));
    }

    @Override
    public void init() {
        for (ClassSubstitutor classSubstitutor : this.substitutors) {
            classSubstitutor.init();
        }
    }

    @Override
    public void shutdown() {
        for (ClassSubstitutor classSubstitutor : this.substitutors) {
            classSubstitutor.shutdown();
        }
    }

    @Override
    public Class<?> getClass(Class<?> cls) {
        Class<?> clsBefore;
        do {
            clsBefore = cls;
            for (ClassSubstitutor substitutor : this.substitutors) {
                cls = substitutor.getClass(cls);
                if (cls != null) continue;
                return null;
            }
        } while (clsBefore != cls);
        return cls;
    }

    @Override
    public void injectInto(Object candidate) {
        if (ClassSubstitutorAware.class.isAssignableFrom(candidate.getClass())) {
            ClassSubstitutorAware cast = (ClassSubstitutorAware)ClassSubstitutorAware.class.cast(candidate);
            cast.setClassSubstitutor(this);
        }
    }
}

