/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.actions.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.facets.actions.debug.DebugFacet;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.actions.exploration.ExplorationFacet;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.prototype.PrototypeFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgumentContext;
import org.apache.isis.core.metamodel.interactions.ActionInvocationContext;
import org.apache.isis.core.metamodel.interactions.ActionUsabilityContext;
import org.apache.isis.core.metamodel.interactions.ActionVisibilityContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterParseable;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectActionImpl
extends ObjectMemberAbstract
implements ObjectAction {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectActionImpl.class);
    private List<ObjectActionParameter> parameters;

    public static ActionType getType(String typeStr) {
        ActionType type = ActionType.valueOf(typeStr);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public ObjectActionImpl(FacetedMethod facetedMethod, ObjectMemberContext objectMemberContext) {
        super(facetedMethod, FeatureType.ACTION, objectMemberContext);
    }

    @Override
    public ObjectSpecification getSpecification() {
        return null;
    }

    @Override
    public ObjectSpecification getReturnType() {
        ActionInvocationFacet facet = this.getActionInvocationFacet();
        return facet.getReturnType();
    }

    @Override
    public boolean hasReturn() {
        if (this.getReturnType() == null) {
            return false;
        }
        return this.getReturnType() != this.getSpecificationLookup().loadSpecification(Void.TYPE);
    }

    @Override
    public ObjectSpecification getOnType() {
        ActionInvocationFacet facet = this.getActionInvocationFacet();
        return facet.getOnType();
    }

    @Override
    public ActionSemantics.Of getSemantics() {
        ActionSemanticsFacet facet = this.getFacet(ActionSemanticsFacet.class);
        return facet != null ? (ActionSemantics.Of)facet.value() : ActionSemantics.Of.NON_IDEMPOTENT;
    }

    @Override
    public Instance getInstance(ObjectAdapter adapter) {
        ObjectActionImpl specification = this;
        return adapter.getInstance(specification);
    }

    @Override
    public ActionType getType() {
        return ObjectActionImpl.getType(this);
    }

    private static ActionType getType(FacetHolder facetHolder) {
        Facet facet = facetHolder.getFacet(DebugFacet.class);
        if (facet != null) {
            return ActionType.DEBUG;
        }
        facet = facetHolder.getFacet(ExplorationFacet.class);
        if (facet != null) {
            return ActionType.EXPLORATION;
        }
        facet = facetHolder.getFacet(PrototypeFacet.class);
        if (facet != null) {
            return ActionType.PROTOTYPE;
        }
        return ActionType.USER;
    }

    @Override
    public int getParameterCount() {
        return this.getFacetedMethod().getParameters().size();
    }

    @Override
    public boolean promptForParameters(ObjectAdapter target) {
        return this.getParameterCount() != 0;
    }

    @Override
    public synchronized List<ObjectActionParameter> getParameters() {
        if (this.parameters == null) {
            int parameterCount = this.getParameterCount();
            ArrayList parameters = Lists.newArrayList();
            List<FacetedMethodParameter> paramPeers = this.getFacetedMethod().getParameters();
            for (int i = 0; i < parameterCount; ++i) {
                ObjectActionParameterAbstract parameter;
                TypedHolder paramPeer = paramPeers.get(i);
                ObjectSpecification specification = ObjectMemberAbstract.getSpecification(this.getSpecificationLookup(), paramPeer.getType());
                if (specification.isParseable()) {
                    parameter = new ObjectActionParameterParseable(i, this, paramPeer);
                } else if (specification.isNotCollection()) {
                    parameter = new OneToOneActionParameterImpl(i, this, paramPeer);
                } else {
                    if (specification.isParentedOrFreeCollection()) {
                        throw new UnknownTypeException("collections not supported as parameters: " + this.getIdentifier());
                    }
                    throw new UnknownTypeException(specification);
                }
                parameters.add(parameter);
            }
            this.parameters = parameters;
        }
        return this.parameters;
    }

    @Override
    public synchronized List<ObjectSpecification> getParameterTypes() {
        ArrayList parameterTypes = Lists.newArrayList();
        List<ObjectActionParameter> parameters = this.getParameters();
        for (ObjectActionParameter parameter : parameters) {
            parameterTypes.add(parameter.getSpecification());
        }
        return parameterTypes;
    }

    @Override
    public ObjectActionParameter getParameterById(String paramId) {
        List<ObjectActionParameter> allParameters = this.getParameters();
        for (int i = 0; i < allParameters.size(); ++i) {
            ObjectActionParameter param = allParameters.get(i);
            if (!Objects.equal((Object)paramId, (Object)param.getId())) continue;
            return param;
        }
        return null;
    }

    @Override
    public ObjectActionParameter getParameterByName(String paramName) {
        List<ObjectActionParameter> allParameters = this.getParameters();
        for (int i = 0; i < allParameters.size(); ++i) {
            ObjectActionParameter param = allParameters.get(i);
            if (!Objects.equal((Object)paramName, (Object)param.getName())) continue;
            return param;
        }
        return null;
    }

    @Override
    public List<ObjectActionParameter> getParameters(Filter<ObjectActionParameter> filter) {
        List<ObjectActionParameter> allParameters = this.getParameters();
        ArrayList selectedParameters = Lists.newArrayList();
        for (int i = 0; i < allParameters.size(); ++i) {
            if (!filter.accept((Object)allParameters.get(i))) continue;
            selectedParameters.add(allParameters.get(i));
        }
        return selectedParameters;
    }

    private ObjectActionParameter getParameter(int position) {
        List<ObjectActionParameter> parameters = this.getParameters();
        if (position >= parameters.size()) {
            throw new IllegalArgumentException("getParameter(int): only " + parameters.size() + " parameters, position=" + position);
        }
        return parameters.get(position);
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter targetObjectAdapter, Where where) {
        return new ActionVisibilityContext(this.getDeploymentCategory(), session, invocationMethod, targetObjectAdapter, this.getIdentifier(), where);
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter targetObjectAdapter, Where where) {
        return new ActionUsabilityContext(this.getDeploymentCategory(), session, invocationMethod, targetObjectAdapter, this.getIdentifier(), where);
    }

    @Override
    public Consent isProposedArgumentSetValid(ObjectAdapter target, ObjectAdapter[] proposedArguments) {
        return this.isProposedArgumentSetValidResultSet(target, proposedArguments).createConsent();
    }

    private InteractionResultSet isProposedArgumentSetValidResultSet(ObjectAdapter object, ObjectAdapter[] proposedArguments) {
        InteractionInvocationMethod invocationMethod = InteractionInvocationMethod.BY_USER;
        InteractionResultSet resultSet = new InteractionResultSet();
        List<ObjectActionParameter> actionParameters = this.getParameters();
        if (proposedArguments != null) {
            for (int i = 0; i < proposedArguments.length; ++i) {
                ActionArgumentContext ic = actionParameters.get(i).createProposedArgumentInteractionContext(this.getAuthenticationSession(), invocationMethod, object, proposedArguments, i);
                InteractionUtils.isValidResultSet(this.getParameter(i), ic, resultSet);
            }
        }
        if (resultSet.isAllowed()) {
            ActionInvocationContext ic = this.createActionInvocationInteractionContext(this.getAuthenticationSession(), invocationMethod, object, proposedArguments);
            InteractionUtils.isValidResultSet(this, ic, resultSet);
        }
        return resultSet;
    }

    @Override
    public ActionInvocationContext createActionInvocationInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter targetObject, ObjectAdapter[] proposedArguments) {
        return new ActionInvocationContext(this.getDeploymentCategory(), this.getAuthenticationSession(), invocationMethod, targetObject, this.getIdentifier(), proposedArguments);
    }

    @Override
    public ObjectAdapter execute(ObjectAdapter target, ObjectAdapter[] arguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("execute action " + target + "." + this.getId());
        }
        ActionInvocationFacet facet = this.getFacet(ActionInvocationFacet.class);
        return facet.invoke(this, target, arguments);
    }

    protected ActionInvocationFacet getActionInvocationFacet() {
        return this.getFacetedMethod().getFacet(ActionInvocationFacet.class);
    }

    @Override
    public ObjectAdapter[] getDefaults(ObjectAdapter target) {
        int i;
        Object[] parameterDefaultPojos;
        int parameterCount = this.getParameterCount();
        List<ObjectActionParameter> parameters = this.getParameters();
        ActionDefaultsFacet facet = this.getFacet(ActionDefaultsFacet.class);
        if (!facet.isNoop()) {
            parameterDefaultPojos = facet.getDefaults(target);
            if (parameterDefaultPojos.length != parameterCount) {
                throw new DomainModelException("Defaults array of incompatible size; expected " + parameterCount + " elements, but was " + parameterDefaultPojos.length + " for " + facet);
            }
            for (i = 0; i < parameterCount; ++i) {
                ObjectSpecification parameterSpec;
                ObjectSpecification componentSpec;
                if (parameterDefaultPojos[i] == null || (componentSpec = this.getSpecificationLookup().loadSpecification(parameterDefaultPojos[i].getClass())).isOfType(parameterSpec = parameters.get(i).getSpecification())) continue;
                throw new DomainModelException("Defaults type incompatible with parameter " + (i + 1) + " type; expected " + parameterSpec.getFullIdentifier() + ", but was " + componentSpec.getFullIdentifier());
            }
        } else {
            parameterDefaultPojos = new Object[parameterCount];
            for (i = 0; i < parameterCount; ++i) {
                ActionParameterDefaultsFacet paramFacet = parameters.get(i).getFacet(ActionParameterDefaultsFacet.class);
                parameterDefaultPojos[i] = paramFacet != null && !paramFacet.isNoop() ? paramFacet.getDefault(target, null) : null;
            }
        }
        ObjectAdapter[] parameterDefaultAdapters = new ObjectAdapter[parameterCount];
        if (parameterDefaultPojos != null) {
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                parameterDefaultAdapters[i2] = this.adapterFor(parameterDefaultPojos[i2]);
            }
        }
        return parameterDefaultAdapters;
    }

    private ObjectAdapter adapterFor(Object pojo) {
        return pojo == null ? null : this.getAdapterManager().adapterFor(pojo);
    }

    @Override
    public ObjectAdapter[][] getChoices(ObjectAdapter target) {
        Object[][] parameterChoicesPojos;
        int parameterCount = this.getParameterCount();
        ActionChoicesFacet facet = this.getFacet(ActionChoicesFacet.class);
        List<ObjectActionParameter> parameters = this.getParameters();
        if (!facet.isNoop()) {
            parameterChoicesPojos = facet.getChoices(target);
            if (parameterChoicesPojos == null) {
                parameterChoicesPojos = new Object[parameterCount][];
            } else if (parameterChoicesPojos.length != parameterCount) {
                throw new DomainModelException("Choices array of incompatible size; expected " + parameterCount + " elements, but was " + parameterChoicesPojos.length + " for " + facet);
            }
        } else {
            parameterChoicesPojos = new Object[parameterCount][];
            for (int i = 0; i < parameterCount; ++i) {
                ActionParameterChoicesFacet paramFacet = parameters.get(i).getFacet(ActionParameterChoicesFacet.class);
                parameterChoicesPojos[i] = paramFacet != null && !paramFacet.isNoop() ? paramFacet.getChoices(target, null) : new Object[0];
            }
        }
        ObjectAdapter[][] parameterChoicesAdapters = new ObjectAdapter[parameterCount][];
        for (int i = 0; i < parameterCount; ++i) {
            ObjectSpecification paramSpec = parameters.get(i).getSpecification();
            if (parameterChoicesPojos[i] != null && parameterChoicesPojos[i].length > 0) {
                ObjectActionParameterAbstract.checkChoicesOrAutoCompleteType(this.getSpecificationLookup(), parameterChoicesPojos[i], paramSpec);
                parameterChoicesAdapters[i] = new ObjectAdapter[parameterChoicesPojos[i].length];
                for (int j = 0; j < parameterChoicesPojos[i].length; ++j) {
                    parameterChoicesAdapters[i][j] = this.adapterFor(parameterChoicesPojos[i][j]);
                }
            } else if (paramSpec.isNotCollection()) {
                parameterChoicesAdapters[i] = new ObjectAdapter[0];
            } else {
                throw new UnknownTypeException(paramSpec);
            }
            if (parameterChoicesAdapters[i].length != 0) continue;
            parameterChoicesAdapters[i] = null;
        }
        return parameterChoicesAdapters;
    }

    @Override
    public String debugData() {
        DebugString debugString = new DebugString();
        this.getFacetedMethod().debugData(debugString);
        return debugString.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Action [");
        sb.append(super.toString());
        sb.append(",type=");
        sb.append((Object)this.getType());
        sb.append(",returns=");
        sb.append(this.getReturnType());
        sb.append(",parameters={");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getParameters().get(i).getSpecification().getShortIdentifier());
        }
        sb.append("}]");
        return sb.toString();
    }
}

